/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.factories;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.EnhNodeFilter;
import org.apache.jena.ontapi.common.EnhNodeFinder;
import org.apache.jena.ontapi.common.EnhNodeProducer;
import org.apache.jena.ontapi.common.OntConfig;
import org.apache.jena.ontapi.common.OntEnhGraph;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.impl.factories.STDObjectFactories;
import org.apache.jena.ontapi.impl.objects.OntDisjointImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;

final class OntDisjoints {
    public static final EnhNodeFinder PROPERTIES_FINDER = new EnhNodeFinder.ByType(OWL2.AllDisjointProperties);
    public static final EnhNodeFinder DISJOINT_FINDER = OntEnhNodeFactories.createFinder(OWL2.AllDisjointClasses, OWL2.AllDifferent, OWL2.AllDisjointProperties);

    OntDisjoints() {
    }

    public static EnhNodeFactory createDLFullDifferentIndividualsFactory(OntConfig config) {
        boolean useDistinctMembers = config.getBoolean(OntModelControls.USE_OWL1_DISTINCT_MEMBERS_PREDICATE_FEATURE);
        boolean compatible = config.getBoolean(OntModelControls.USE_OWL2_DEPRECATED_VOCABULARY_FEATURE);
        Property[] predicates = useDistinctMembers ? new Property[]{OWL2.distinctMembers} : (compatible ? new Property[]{OWL2.members, OWL2.distinctMembers} : new Property[]{OWL2.members});
        return OntDisjoints.createFactory(OntDisjointImpl.IndividualsImpl.class, (n, g) -> new OntDisjointImpl.IndividualsImpl((Node)n, (EnhGraph)g, !compatible, useDistinctMembers), OWL2.AllDifferent, OntIndividual.class, it -> true, 1, predicates);
    }

    public static EnhNodeFactory createELQLRLDifferentIndividualsFactory() {
        return OntDisjoints.createFactory(OntDisjointImpl.IndividualsImpl.class, (n, g) -> new OntDisjointImpl.IndividualsImpl((Node)n, (EnhGraph)g, true, false), OWL2.AllDifferent, OntIndividual.class, it -> true, 2, OWL2.members);
    }

    public static EnhNodeFactory createDisjointObjectPropertiesFactory(int atLeastN) {
        return OntDisjoints.createFactory(OntDisjointImpl.ObjectPropertiesImpl.class, OntDisjointImpl.ObjectPropertiesImpl::new, OWL2.AllDisjointProperties, OntObjectProperty.class, it -> true, atLeastN, OWL2.members);
    }

    public static EnhNodeFactory createDisjointDataPropertiesFactory(int atLeastN) {
        return OntDisjoints.createFactory(OntDisjointImpl.DataPropertiesImpl.class, OntDisjointImpl.DataPropertiesImpl::new, OWL2.AllDisjointProperties, OntDataProperty.class, it -> true, atLeastN, OWL2.members);
    }

    public static EnhNodeFactory createDisjointClassesFactory(int atLeastN) {
        return OntDisjoints.createFactory(OntDisjointImpl.QLRLClassesImpl.class, OntDisjointImpl.QLRLClassesImpl::new, OWL2.AllDisjointClasses, OntClass.class, it -> true, atLeastN, OWL2.members);
    }

    public static EnhNodeFactory createQLRLDisjointClassesFactory() {
        return OntDisjoints.createFactory(OntDisjointImpl.QLRLClassesImpl.class, OntDisjointImpl.QLRLClassesImpl::new, OWL2.AllDisjointClasses, OntClass.class, OntClass::canAsDisjointClass, 2, OWL2.members);
    }

    private static <X extends RDFNode> EnhNodeFactory createFactory(Class<? extends OntDisjointImpl<?>> impl, BiFunction<Node, EnhGraph, EnhNode> producer, Resource rdfType, Class<X> memberType, Predicate<X> testMember, int atLeastN, Property ... membersPredicates) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(impl, rdfType, producer);
        EnhNodeFinder.ByType finder = new EnhNodeFinder.ByType(rdfType);
        EnhNodeFilter filter = EnhNodeFilter.ANON.and(new EnhNodeFilter.HasType(rdfType)).and((n, g) -> {
            try (ExtendedIterator res = membersPredicates.length == 1 ? g.asGraph().find(n, membersPredicates[0].asNode(), Node.ANY) : Iterators.flatMap(Iterators.of(membersPredicates), it -> g.asGraph().find(n, it.asNode(), Node.ANY));){
                while (res.hasNext()) {
                    Node listNode = ((Triple)res.next()).getObject();
                    if (!STDObjectFactories.RDF_LIST.canWrap(listNode, g)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (atLeastN == 0) {
                        boolean bl = true;
                        return bl;
                    }
                    RDFList list = (RDFList)STDObjectFactories.RDF_LIST.wrap(listNode, g);
                    if (!Iterators.hasAtLeast(list.iterator().mapWith(it -> OntEnhGraph.asPersonalityModel(g).findNodeAs(it.asNode(), memberType)).filterKeep(it -> it != null && testMember.test(it)), atLeastN)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
        return OntEnhNodeFactories.createCommon(maker, (EnhNodeFinder)finder, filter, new EnhNodeFilter[0]);
    }
}

