/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.system;

import java.util.Map;
import org.apache.jena.shared.PrefixMapping;

public class PrefixMappingMonitor
implements PrefixMapping {
    private final PrefixMapping pmap;

    public PrefixMappingMonitor(PrefixMapping pmap) {
        this.pmap = pmap;
    }

    protected PrefixMapping get() {
        return this.pmap;
    }

    protected void set(String prefix, String uri) {
    }

    protected void remove(String prefix) {
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.set(prefix, uri);
        this.get().setNsPrefix(prefix, uri);
        return this;
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        this.remove(prefix);
        this.get().removeNsPrefix(prefix);
        return this;
    }

    public PrefixMapping clearNsPrefixMap() {
        this.get().getNsPrefixMap().forEach((prefix, uri) -> this.remove((String)prefix));
        this.get().clearNsPrefixMap();
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        other.getNsPrefixMap().forEach((p, u) -> this.set((String)p, (String)u));
        this.get().setNsPrefixes(other);
        return this;
    }

    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        map.forEach((p, u) -> this.set((String)p, (String)u));
        this.get().setNsPrefixes(map);
        return this;
    }

    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        map.getNsPrefixMap().forEach((p, u) -> this.set((String)p, (String)u));
        this.get().withDefaultMappings(map);
        return this;
    }

    public String getNsPrefixURI(String prefix) {
        return this.get().getNsPrefixURI(prefix);
    }

    public String getNsURIPrefix(String uri) {
        return this.get().getNsURIPrefix(uri);
    }

    public Map<String, String> getNsPrefixMap() {
        return this.get().getNsPrefixMap();
    }

    public String expandPrefix(String prefixed) {
        return this.get().expandPrefix(prefixed);
    }

    public String shortForm(String uri) {
        return this.get().shortForm(uri);
    }

    public String qnameFor(String uri) {
        return this.get().qnameFor(uri);
    }

    public PrefixMapping lock() {
        this.get().lock();
        return this;
    }

    public boolean hasNoMappings() {
        return this.get().hasNoMappings();
    }

    public int numPrefixes() {
        return this.get().numPrefixes();
    }

    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.get().samePrefixMappingAs(other);
    }
}

