/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sys;

import org.apache.jena.base.module.Subsystem;
import org.apache.jena.base.module.SubsystemLifecycle;
import org.apache.jena.base.module.SubsystemRegistry;
import org.apache.jena.base.module.SubsystemRegistryServiceLoader;
import org.apache.jena.sys.JenaSubsystemLifecycle;

public class JenaSystem {
    private static Subsystem<JenaSubsystemLifecycle> singleton = null;
    public static boolean DEBUG_INIT = false;
    private static volatile boolean initialized = false;

    public static void logLifecycle(String fmt, Object ... args) {
        if (!DEBUG_INIT) {
            return;
        }
        System.err.printf(fmt, args);
        System.err.println();
    }

    public static void init() {
        JenaSystem.init(false);
    }

    public static void init(boolean withTracing) {
        if (initialized) {
            return;
        }
        if (withTracing) {
            DEBUG_INIT = true;
        }
        boolean unused = LazyInitializer.IS_INITIALIZED;
    }

    public static void shutdown() {
        singleton.shutdown();
    }

    private static void setup() {
        try {
            if (singleton == null) {
                singleton = new Subsystem(JenaSubsystemLifecycle.class);
                SubsystemRegistryServiceLoader reg = new SubsystemRegistryServiceLoader(JenaSubsystemLifecycle.class);
                singleton.setSubsystemRegistry((SubsystemRegistry)reg);
                reg.add((SubsystemLifecycle)new JenaInitLevel0());
            }
        }
        catch (Throwable th) {
            System.err.println(">> JenaSystem initialization");
            System.err.println(th.getMessage());
            if (th.getCause() != null) {
                System.err.println(th.getCause().getMessage());
            }
            System.err.println("----");
            th.printStackTrace();
            System.err.println("<< JenaSystem initialization");
            throw th;
        }
    }

    private static class LazyInitializer {
        static final boolean IS_INITIALIZED = LazyInitializer.jenaSystemInitialization();

        private LazyInitializer() {
        }

        private static boolean jenaSystemInitialization() {
            initialized = true;
            JenaSystem.setup();
            if (DEBUG_INIT) {
                singleton.debug(DEBUG_INIT);
            }
            singleton.initialize();
            singleton.debug(false);
            return true;
        }
    }

    private static class JenaInitLevel0
    implements JenaSubsystemLifecycle {
        private JenaInitLevel0() {
        }

        public void start() {
            JenaSystem.logLifecycle("Jena initialization", new Object[0]);
        }

        public void stop() {
            JenaSystem.logLifecycle("Jena shutdown", new Object[0]);
        }

        public int level() {
            return 0;
        }
    }
}

