/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.log;

import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HookResultLogger
implements HookResultHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(HookResultLogger.class);

    @Override
    public HookResult onHookResult(SMTPSession session, HookResult hResult, long executionTime, Hook hook) {
        boolean requiresInfoLogging;
        HookReturnCode result = hResult.getResult();
        boolean bl = requiresInfoLogging = result.getAction() == HookReturnCode.Action.DENY || result.getAction() == HookReturnCode.Action.DENYSOFT || result.isDisconnected();
        if (requiresInfoLogging) {
            LOGGER.info("{}: result= ({} {}) {} {}", new Object[]{hook.getClass().getName(), result.getAction(), result.getConnectionStatus(), hResult.getSmtpRetCode(), hResult.getSmtpDescription()});
        } else {
            LOGGER.trace("{}: result= ({} {})", new Object[]{hook.getClass().getName(), result.getAction(), result.getConnectionStatus()});
        }
        return hResult;
    }
}

