/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.api;

import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.apache.james.core.Username;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.util.ValuePatch;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.VacationPatch;
import org.apache.james.vacation.api.VacationRepository;
import org.reactivestreams.Publisher;

public class VacationDeleteUserTaskStep
implements DeleteUserDataTaskStep {
    private final VacationRepository vacationRepository;

    @Inject
    public VacationDeleteUserTaskStep(VacationRepository vacationRepository) {
        this.vacationRepository = vacationRepository;
    }

    @Override
    public DeleteUserDataTaskStep.StepName name() {
        return new DeleteUserDataTaskStep.StepName("VacationDeleteUserTaskStep");
    }

    @Override
    public int priority() {
        return 4;
    }

    @Override
    public Publisher<Void> deleteUserData(Username username) {
        return this.vacationRepository.modifyVacation(AccountId.fromUsername(username), VacationPatch.builder().isEnabled(false).subject((ValuePatch<String>)ValuePatch.remove()).fromDate((ValuePatch<ZonedDateTime>)ValuePatch.remove()).htmlBody((ValuePatch<String>)ValuePatch.remove()).textBody((ValuePatch<String>)ValuePatch.remove()).toDate((ValuePatch<ZonedDateTime>)ValuePatch.remove()).build());
    }
}

