/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionRunner.class);
    public static final Function<PersistenceException, Object> IGNORE_EXCEPTION = e -> null;
    private final EntityManagerFactory entityManagerFactory;

    public TransactionRunner(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void run(Consumer<EntityManager> runnable) {
        this.runAndRetrieveResult(entityManager -> {
            runnable.accept((EntityManager)entityManager);
            return null;
        }, IGNORE_EXCEPTION);
    }

    public <T> T runAndRetrieveResult(Function<EntityManager, T> toResult) {
        return (T)this.runAndRetrieveResult(toResult, e -> {
            throw new RuntimeException((Throwable)e);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAndRetrieveResult(Function<EntityManager, T> toResult, Function<PersistenceException, T> errorHandler) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            T result = toResult.apply(entityManager);
            transaction.commit();
            T t = result;
            return t;
        }
        catch (PersistenceException e) {
            LOGGER.warn("Could not execute transaction", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            T t = errorHandler.apply(e);
            return t;
        }
        finally {
            EntityManagerUtils.safelyClose(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAndHandleException(Consumer<EntityManager> runnable, Consumer<PersistenceException> errorHandler) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            runnable.accept(entityManager);
            transaction.commit();
        }
        catch (PersistenceException e) {
            LOGGER.warn("Could not execute transaction", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            errorHandler.accept(e);
        }
        finally {
            EntityManagerUtils.safelyClose(entityManager);
        }
    }
}

