/*
 * Decompiled with CFR 0.152.
 */
package spark.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.ExceptionMapper;
import spark.globalstate.ServletFlag;
import spark.http.matching.MatcherFilter;
import spark.route.ServletRoutes;
import spark.servlet.FilterTools;
import spark.servlet.SparkApplication;
import spark.staticfiles.StaticFilesConfiguration;
import spark.utils.StringUtils;

public class SparkFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(SparkFilter.class);
    public static final String APPLICATION_CLASS_PARAM = "applicationClass";
    private String filterPath;
    private MatcherFilter matcherFilter;
    private SparkApplication[] applications;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletFlag.runFromServlet();
        for (SparkApplication application : this.applications = this.getApplications(filterConfig)) {
            application.init();
        }
        this.filterPath = FilterTools.getFilterPath(filterConfig);
        this.matcherFilter = new MatcherFilter(ServletRoutes.get(), StaticFilesConfiguration.servletInstance, ExceptionMapper.getServletInstance(), true, false);
    }

    @Deprecated
    protected SparkApplication getApplication(FilterConfig filterConfig) throws ServletException {
        return this.getApplication(filterConfig.getInitParameter(APPLICATION_CLASS_PARAM));
    }

    protected SparkApplication getApplication(String applicationClassName) throws ServletException {
        try {
            Class<?> applicationClass = Class.forName(applicationClassName);
            return (SparkApplication)applicationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exc) {
            throw new ServletException((Throwable)exc);
        }
    }

    protected SparkApplication[] getApplications(FilterConfig filterConfig) throws ServletException {
        String applications = filterConfig.getInitParameter(APPLICATION_CLASS_PARAM);
        SparkApplication[] solvedApplications = null;
        if (StringUtils.isNotBlank(applications)) {
            String[] sparkApplications = applications.split(",");
            if (sparkApplications.length > 0) {
                solvedApplications = new SparkApplication[sparkApplications.length];
                for (int index = 0; index < sparkApplications.length; ++index) {
                    solvedApplications[index] = this.getApplication(sparkApplications[index].trim());
                }
            } else {
                throw new ServletException("There are no Spark applications configured in the filter.");
            }
        }
        return solvedApplications;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        final String relativePath = FilterTools.getRelativePath(httpRequest, this.filterPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug(relativePath);
        }
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(httpRequest){

            public String getPathInfo() {
                return relativePath;
            }

            public String getRequestURI() {
                return relativePath;
            }
        };
        boolean consumed = StaticFilesConfiguration.servletInstance.consume(httpRequest, httpResponse);
        if (consumed) {
            return;
        }
        this.matcherFilter.doFilter((ServletRequest)requestWrapper, response, chain);
    }

    public void destroy() {
        if (this.applications != null) {
            for (SparkApplication sparkApplication : this.applications) {
                sparkApplication.destroy();
            }
        }
    }
}

