/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.queue.activemq;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import jakarta.jms.ConnectionFactory;
import java.io.FileNotFoundException;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.queue.activemq.ActiveMQConfiguration;
import org.apache.james.queue.activemq.ActiveMQHealthCheck;
import org.apache.james.queue.activemq.ActiveMQMailQueueFactory;
import org.apache.james.queue.activemq.EmbeddedActiveMQ;
import org.apache.james.queue.activemq.metric.ActiveMQMetricCollector;
import org.apache.james.queue.activemq.metric.ActiveMQMetricCollectorImpl;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQQueueModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQQueueModule.class);
    private static final String FILENAME = "activemq";

    protected void configure() {
        this.bind(PersistenceAdapter.class).to(KahaDBPersistenceAdapter.class);
        this.bind(KahaDBPersistenceAdapter.class).in(Scopes.SINGLETON);
        this.bind(EmbeddedActiveMQ.class).in(Scopes.SINGLETON);
        this.bind(ActiveMQMailQueueFactory.class).in(Scopes.SINGLETON);
        this.bind(ActiveMQMetricCollector.class).to(ActiveMQMetricCollectorImpl.class);
        this.bind(ActiveMQMetricCollectorImpl.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(ActiveMQHealthCheck.class);
    }

    @Provides
    @Singleton
    ConnectionFactory provideEmbededActiveMQ(EmbeddedActiveMQ embeddedActiveMQ) {
        return embeddedActiveMQ.getConnectionFactory();
    }

    @Provides
    @Singleton
    public MailQueueFactory<? extends ManageableMailQueue> createActiveMQManageableMailQueueFactory(ActiveMQMailQueueFactory activeMQMailQueueFactory) {
        activeMQMailQueueFactory.setUseJMX(true);
        activeMQMailQueueFactory.init();
        return activeMQMailQueueFactory;
    }

    @Provides
    @Singleton
    public MailQueueFactory<?> provideActiveMQMailQueueFactory(MailQueueFactory<? extends ManageableMailQueue> mailQueueFactory) {
        return mailQueueFactory;
    }

    @Provides
    @Singleton
    public MailQueueFactory<? extends MailQueue> provideMailQueueFactoryGenerics(ActiveMQMailQueueFactory queueFactory) {
        return queueFactory;
    }

    @Singleton
    @Provides
    ActiveMQConfiguration activeMQConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfigurations(new String[]{FILENAME});
            return ActiveMQConfiguration.from((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find {} configuration file, using default configuration", (Object)FILENAME);
            return ActiveMQConfiguration.getDefault();
        }
    }

    @ProvidesIntoSet
    InitializationOperation configureMetricCollector(ActiveMQMetricCollector metricCollector) {
        return InitilizationOperationBuilder.forClass(ActiveMQMetricCollector.class).init(() -> ((ActiveMQMetricCollector)metricCollector).start());
    }
}

