/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model;

import com.google.common.base.Objects;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.lang.reflect.Field;
import org.apache.james.mailbox.jpa.mail.model.JPAMailboxAnnotationId;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.ObjectId;

@Entity(name="MailboxAnnotation")
@Table(name="JAMES_MAILBOX_ANNOTATION")
@NamedQueries(value={@NamedQuery(name="retrieveAllAnnotations", query="SELECT annotation FROM MailboxAnnotation annotation WHERE annotation.mailboxId = :idParam"), @NamedQuery(name="retrieveByKey", query="SELECT annotation FROM MailboxAnnotation annotation WHERE annotation.mailboxId = :idParam AND annotation.key = :keyParam"), @NamedQuery(name="countAnnotationsInMailbox", query="SELECT COUNT(annotation) FROM MailboxAnnotation annotation WHERE annotation.mailboxId = :idParam"), @NamedQuery(name="retrieveByKeyLike", query="SELECT annotation FROM MailboxAnnotation annotation WHERE annotation.mailboxId = :idParam AND annotation.key LIKE :keyParam")})
@IdClass(value=JPAMailboxAnnotationId.class)
public class JPAMailboxAnnotation
implements PersistenceCapable {
    public static final String MAILBOX_ID = "MAILBOX_ID";
    public static final String ANNOTATION_KEY = "ANNOTATION_KEY";
    public static final String VALUE = "VALUE";
    @Id
    @Column(name="MAILBOX_ID")
    private long mailboxId;
    @Id
    @Column(name="ANNOTATION_KEY", length=200)
    private String key;
    @Basic
    @Column(name="VALUE")
    private String value;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    private transient Object pcDetachedState;

    public JPAMailboxAnnotation() {
    }

    public JPAMailboxAnnotation(long mailboxId, String key, String value) {
        this.mailboxId = mailboxId;
        this.key = key;
        this.value = value;
    }

    public long getMailboxId() {
        return JPAMailboxAnnotation.pcGetmailboxId(this);
    }

    public String getKey() {
        return JPAMailboxAnnotation.pcGetkey(this);
    }

    public String getValue() {
        return JPAMailboxAnnotation.pcGetvalue(this);
    }

    public void setValue(String value) {
        JPAMailboxAnnotation.pcSetvalue(this, value);
    }

    public boolean equals(Object o) {
        if (o instanceof JPAMailboxAnnotation) {
            JPAMailboxAnnotation that = (JPAMailboxAnnotation)o;
            return Objects.equal((Object)JPAMailboxAnnotation.pcGetmailboxId(this), (Object)JPAMailboxAnnotation.pcGetmailboxId(that)) && Objects.equal((Object)JPAMailboxAnnotation.pcGetkey(this), (Object)JPAMailboxAnnotation.pcGetkey(that)) && Objects.equal((Object)JPAMailboxAnnotation.pcGetvalue(this), (Object)JPAMailboxAnnotation.pcGetvalue(that));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{JPAMailboxAnnotation.pcGetmailboxId(this), JPAMailboxAnnotation.pcGetkey(this), JPAMailboxAnnotation.pcGetvalue(this)});
    }

    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcFieldNames = new String[]{"key", "mailboxId", "value"};
        pcFieldTypes = new Class[]{String.class, Long.TYPE, String.class};
        pcFieldFlags = new byte[]{26, 26, 26};
        PCRegistry.register(JPAMailboxAnnotation.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"MailboxAnnotation", (PersistenceCapable)new JPAMailboxAnnotation());
    }

    protected void pcClearFields() {
        this.key = null;
        this.mailboxId = 0L;
        this.value = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAMailboxAnnotation jPAMailboxAnnotation = new JPAMailboxAnnotation();
        if (bl) {
            jPAMailboxAnnotation.pcClearFields();
        }
        jPAMailboxAnnotation.pcStateManager = stateManager;
        jPAMailboxAnnotation.pcCopyKeyFieldsFromObjectId(object);
        return jPAMailboxAnnotation;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAMailboxAnnotation jPAMailboxAnnotation = new JPAMailboxAnnotation();
        if (bl) {
            jPAMailboxAnnotation.pcClearFields();
        }
        jPAMailboxAnnotation.pcStateManager = stateManager;
        return jPAMailboxAnnotation;
    }

    protected static int pcGetManagedFieldCount() {
        return 3;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.key = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.mailboxId = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.value = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.key);
                return;
            }
            case 1: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.mailboxId);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.value);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAMailboxAnnotation jPAMailboxAnnotation, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.key = jPAMailboxAnnotation.key;
                return;
            }
            case 1: {
                this.mailboxId = jPAMailboxAnnotation.mailboxId;
                return;
            }
            case 2: {
                this.value = jPAMailboxAnnotation.value;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JPAMailboxAnnotation jPAMailboxAnnotation = (JPAMailboxAnnotation)object;
        if (jPAMailboxAnnotation.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAMailboxAnnotation, nArray[i]);
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        JPAMailboxAnnotationId jPAMailboxAnnotationId = (JPAMailboxAnnotationId)((ObjectId)object).getId();
        int n = pcInheritedFieldCount;
        Reflection.set((Object)jPAMailboxAnnotationId, (Field)Reflection.findField(JPAMailboxAnnotationId.class, (String)"key", (boolean)true), (Object)fieldSupplier.fetchStringField(0 + n));
        Reflection.set((Object)jPAMailboxAnnotationId, (Field)Reflection.findField(JPAMailboxAnnotationId.class, (String)"mailboxId", (boolean)true), (long)fieldSupplier.fetchLongField(1 + n));
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        JPAMailboxAnnotationId jPAMailboxAnnotationId = (JPAMailboxAnnotationId)((ObjectId)object).getId();
        Reflection.set((Object)jPAMailboxAnnotationId, (Field)Reflection.findField(JPAMailboxAnnotationId.class, (String)"key", (boolean)true), (Object)this.key);
        Reflection.set((Object)jPAMailboxAnnotationId, (Field)Reflection.findField(JPAMailboxAnnotationId.class, (String)"mailboxId", (boolean)true), (long)this.mailboxId);
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        JPAMailboxAnnotationId jPAMailboxAnnotationId = (JPAMailboxAnnotationId)((ObjectId)object).getId();
        fieldConsumer.storeStringField(0 + pcInheritedFieldCount, (String)Reflection.get((Object)jPAMailboxAnnotationId, (Field)Reflection.findField(JPAMailboxAnnotationId.class, (String)"key", (boolean)true)));
        fieldConsumer.storeLongField(1 + pcInheritedFieldCount, Reflection.getLong((Object)jPAMailboxAnnotationId, (Field)Reflection.findField(JPAMailboxAnnotationId.class, (String)"mailboxId", (boolean)true)));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        JPAMailboxAnnotationId jPAMailboxAnnotationId = (JPAMailboxAnnotationId)((ObjectId)object).getId();
        this.key = (String)Reflection.get((Object)jPAMailboxAnnotationId, (Field)Reflection.findField(JPAMailboxAnnotationId.class, (String)"key", (boolean)true));
        this.mailboxId = Reflection.getLong((Object)jPAMailboxAnnotationId, (Field)Reflection.findField(JPAMailboxAnnotationId.class, (String)"mailboxId", (boolean)true));
    }

    public Object pcNewObjectIdInstance(Object object) {
        throw new IllegalArgumentException("The id type \"class org.apache.james.mailbox.jpa.mail.model.JPAMailboxAnnotationId\" specified by persistent type \"class org.apache.james.mailbox.jpa.mail.model.JPAMailboxAnnotation\" does not have a public class org.apache.james.mailbox.jpa.mail.model.JPAMailboxAnnotationId(String) or class org.apache.james.mailbox.jpa.mail.model.JPAMailboxAnnotationId(Class, String) constructor.");
    }

    public Object pcNewObjectIdInstance() {
        return new ObjectId(JPAMailboxAnnotation.class, (Object)new JPAMailboxAnnotationId());
    }

    private static final String pcGetkey(JPAMailboxAnnotation jPAMailboxAnnotation) {
        if (jPAMailboxAnnotation.pcStateManager == null) {
            return jPAMailboxAnnotation.key;
        }
        int n = pcInheritedFieldCount + 0;
        jPAMailboxAnnotation.pcStateManager.accessingField(n);
        return jPAMailboxAnnotation.key;
    }

    private static final void pcSetkey(JPAMailboxAnnotation jPAMailboxAnnotation, String string) {
        if (jPAMailboxAnnotation.pcStateManager == null) {
            jPAMailboxAnnotation.key = string;
            return;
        }
        jPAMailboxAnnotation.pcStateManager.settingStringField((PersistenceCapable)jPAMailboxAnnotation, pcInheritedFieldCount + 0, jPAMailboxAnnotation.key, string, 0);
    }

    private static final long pcGetmailboxId(JPAMailboxAnnotation jPAMailboxAnnotation) {
        if (jPAMailboxAnnotation.pcStateManager == null) {
            return jPAMailboxAnnotation.mailboxId;
        }
        int n = pcInheritedFieldCount + 1;
        jPAMailboxAnnotation.pcStateManager.accessingField(n);
        return jPAMailboxAnnotation.mailboxId;
    }

    private static final void pcSetmailboxId(JPAMailboxAnnotation jPAMailboxAnnotation, long l) {
        if (jPAMailboxAnnotation.pcStateManager == null) {
            jPAMailboxAnnotation.mailboxId = l;
            return;
        }
        jPAMailboxAnnotation.pcStateManager.settingLongField((PersistenceCapable)jPAMailboxAnnotation, pcInheritedFieldCount + 1, jPAMailboxAnnotation.mailboxId, l, 0);
    }

    private static final String pcGetvalue(JPAMailboxAnnotation jPAMailboxAnnotation) {
        if (jPAMailboxAnnotation.pcStateManager == null) {
            return jPAMailboxAnnotation.value;
        }
        int n = pcInheritedFieldCount + 2;
        jPAMailboxAnnotation.pcStateManager.accessingField(n);
        return jPAMailboxAnnotation.value;
    }

    private static final void pcSetvalue(JPAMailboxAnnotation jPAMailboxAnnotation, String string) {
        if (jPAMailboxAnnotation.pcStateManager == null) {
            jPAMailboxAnnotation.value = string;
            return;
        }
        jPAMailboxAnnotation.pcStateManager.settingStringField((PersistenceCapable)jPAMailboxAnnotation, pcInheritedFieldCount + 2, jPAMailboxAnnotation.value, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

