/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SourceDomainIsNotInDomainListException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

public class DomainMappingsRoutes
implements Routes {
    public static final String DOMAIN_MAPPINGS = "/domainMappings";
    private static final String FROM_DOMAIN = "fromDomain";
    private static final String SPECIFIC_MAPPING = "/domainMappings/:fromDomain";
    private final RecipientRewriteTable recipientRewriteTable;
    private final JsonTransformer jsonTransformer;

    @Inject
    @VisibleForTesting
    DomainMappingsRoutes(RecipientRewriteTable recipientRewriteTable, JsonTransformer jsonTransformer) {
        this.recipientRewriteTable = recipientRewriteTable;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return DOMAIN_MAPPINGS;
    }

    public void define(Service service) {
        service.get(DOMAIN_MAPPINGS, this::getAllMappings, (ResponseTransformer)this.jsonTransformer);
        service.get(SPECIFIC_MAPPING, this::getMapping, (ResponseTransformer)this.jsonTransformer);
        service.put(SPECIFIC_MAPPING, this::addDomainMapping);
        service.delete(SPECIFIC_MAPPING, this::removeDomainMapping);
    }

    public HaltException addDomainMapping(Request request, Response response) throws RecipientRewriteTableException {
        MappingSource mappingSource = this.mappingSourceFrom(request);
        Domain destinationDomain = this.extractDomain(request.body());
        this.addAliasDomainMapping(mappingSource, destinationDomain);
        return Spark.halt((int)204);
    }

    private void addAliasDomainMapping(MappingSource source, Domain destinationDomain) throws RecipientRewriteTableException {
        try {
            this.recipientRewriteTable.addDomainAliasMapping(source, destinationDomain);
        }
        catch (SourceDomainIsNotInDomainListException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(e.getMessage()).haltError();
        }
    }

    public HaltException removeDomainMapping(Request request, Response response) throws RecipientRewriteTableException {
        MappingSource mappingSource = this.mappingSourceFrom(request);
        Domain destinationDomain = this.extractDomain(request.body());
        this.recipientRewriteTable.removeDomainMapping(mappingSource, destinationDomain);
        return Spark.halt((int)204);
    }

    public Map<String, List<String>> getAllMappings(Request request, Response response) throws RecipientRewriteTableException {
        return (Map)this.recipientRewriteTable.getAllMappings().entrySet().stream().filter(mappingsEntry -> ((Mappings)mappingsEntry.getValue()).contains(Mapping.Type.Domain)).collect(ImmutableMap.toImmutableMap(mappingsEntry -> ((MappingSource)mappingsEntry.getKey()).getFixedDomain(), mappingsEntry -> this.toDomainList((Mappings)mappingsEntry.getValue())));
    }

    public List<String> getMapping(Request request, Response response) throws RecipientRewriteTableException {
        MappingSource mappingSource = this.mappingSourceFrom(request);
        return Optional.of(this.recipientRewriteTable.getStoredMappings(mappingSource).select(Mapping.Type.Domain)).filter(mappings -> mappings.contains(Mapping.Type.Domain)).map(this::toDomainList).orElseThrow(() -> ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message(String.format("Cannot find mappings for %s", mappingSource.getFixedDomain())).haltError());
    }

    private MappingSource mappingSourceFrom(Request request) {
        Domain fromDomain = this.extractDomain(request.params(FROM_DOMAIN));
        return MappingSource.fromDomain((Domain)fromDomain);
    }

    private Domain extractDomain(String domainAsString) {
        try {
            return Domain.of((String)domainAsString.trim());
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(String.format("The domain %s is invalid.", domainAsString)).cause((Exception)e).haltError();
        }
    }

    private List<String> toDomainList(Mappings mappings) {
        return (List)mappings.select(Mapping.Type.Domain).asStream().map(Mapping::asString).map(arg_0 -> ((Mapping.Type)Mapping.Type.Domain).withoutPrefix(arg_0)).collect(ImmutableList.toImmutableList());
    }
}

