/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class ModifyColumnNode
extends ColumnDefinitionNode {
    int columnPosition = -1;
    UUID oldDefaultUUID;
    static final int K_MODIFY_COLUMN_TYPE = 0;
    static final int K_MODIFY_COLUMN_DEFAULT = 1;
    static final int K_MODIFY_COLUMN_CONSTRAINT = 2;
    static final int K_MODIFY_COLUMN_CONSTRAINT_NOT_NULL = 3;
    static final int K_DROP_COLUMN = 4;
    static final int K_MODIFY_COLUMN_GENERATED_ALWAYS = 5;
    static final int K_MODIFY_COLUMN_GENERATED_BY_DEFAULT = 6;
    final int kind;

    ModifyColumnNode(int n, String string, ValueNode valueNode, DataTypeDescriptor dataTypeDescriptor, long[] lArray, ContextManager contextManager) throws StandardException {
        super(string, valueNode, dataTypeDescriptor, lArray, contextManager);
        this.kind = n;
    }

    @Override
    UUID getOldDefaultUUID() {
        return this.oldDefaultUUID;
    }

    int getColumnPosition() {
        return this.columnPosition;
    }

    @Override
    void checkUserType(TableDescriptor tableDescriptor) throws StandardException {
        if (this.kind != 0) {
            return;
        }
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", this.name, tableDescriptor.getName());
        }
        DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
        this.setNullability(dataTypeDescriptor.isNullable());
        if (!dataTypeDescriptor.getTypeId().equals(this.getType().getTypeId())) {
            throw StandardException.newException("42Z15", this.name);
        }
        String string = this.getType().getTypeName();
        if (!(string.equals("VARCHAR") || string.equals("VARCHAR () FOR BIT DATA") || string.equals("BLOB") || string.equals("CLOB"))) {
            throw StandardException.newException("42Z16", new Object[0]);
        }
        if (this.getType().getMaximumWidth() < dataTypeDescriptor.getMaximumWidth()) {
            throw StandardException.newException("42Z17", this.name);
        }
    }

    void checkExistingConstraints(TableDescriptor tableDescriptor) throws StandardException {
        if (this.kind != 0 && this.kind != 2 && this.kind != 3) {
            return;
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int[] nArray = new int[]{this.columnPosition};
        for (int i = 0; i < constraintDescriptorList.size(); ++i) {
            Object object;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (!(constraintDescriptor instanceof KeyConstraintDescriptor) || !constraintDescriptor.columnIntersects(nArray)) continue;
            int n = constraintDescriptor.getConstraintType();
            if (n == 6 && this.kind == 0) {
                throw StandardException.newException("42Z18", this.name, constraintDescriptor.getConstraintName());
            }
            if (!dataDictionary.checkVersion(160, null) && this.kind == 2 && constraintDescriptor.getConstraintType() == 3) {
                throw StandardException.newException("42Z20", this.name);
            }
            if (this.kind == 2 && constraintDescriptor.getConstraintType() == 2) {
                object = this.getLanguageConnectionContext().getDataDictionary().checkVersion(160, null) ? "42Z20.S.1" : "42Z20";
                throw StandardException.newException((String)object, this.name);
            }
            object = dataDictionary.getForeignKeys(constraintDescriptor.getUUID());
            if (((ArrayList)object).size() > 0) {
                throw StandardException.newException("42Z19", this.name, ((ConstraintDescriptorList)object).elementAt(0).getConstraintName());
            }
            this.getCompilerContext().createDependency(constraintDescriptor);
        }
    }

    void useExistingCollation(TableDescriptor tableDescriptor) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", this.name, tableDescriptor.getName());
        }
        if (this.getType() != null && this.getType().getTypeId().isStringTypeId()) {
            this.setCollationType(columnDescriptor.getType().getCollationType());
        }
    }

    @Override
    int getAction() {
        switch (this.kind) {
            case 1: {
                if (this.autoinc_create_or_modify_Start_Increment == 1L) {
                    return 5;
                }
                if (this.autoinc_create_or_modify_Start_Increment == 2L) {
                    return 6;
                }
                if (this.autoinc_create_or_modify_Start_Increment == 4L) {
                    return 10;
                }
                return 7;
            }
            case 0: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 9;
            }
        }
        return 0;
    }

    @Override
    void bindAndValidateDefault(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", this.name, tableDescriptor.getName());
        }
        DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(dataDictionary);
        this.oldDefaultUUID = defaultDescriptor == null ? null : defaultDescriptor.getUUID();
        this.columnPosition = columnDescriptor.getPosition();
        if (this.kind != 1) {
            return;
        }
        if (this.keepCurrentDefault) {
            this.defaultInfo = (DefaultInfoImpl)columnDescriptor.getDefaultInfo();
        } else if (columnDescriptor.hasGenerationClause() || columnDescriptor.isAutoincrement()) {
            throw StandardException.newException("42XA7", columnDescriptor.getColumnName());
        }
        if (this.autoinc_create_or_modify_Start_Increment == 1L) {
            this.autoincrementIncrement = columnDescriptor.getAutoincInc();
            this.autoincrementCycle = columnDescriptor.getAutoincCycle();
        }
        if (this.autoinc_create_or_modify_Start_Increment == 2L) {
            this.autoincrementStart = columnDescriptor.getAutoincStart();
            this.autoincrementCycle = columnDescriptor.getAutoincCycle();
        }
        if (this.autoinc_create_or_modify_Start_Increment == 4L) {
            this.autoincrementIncrement = columnDescriptor.getAutoincInc();
            this.autoincrementStart = columnDescriptor.getAutoincStart();
        }
        this.type = columnDescriptor.getType();
        this.validateDefault(dataDictionary, tableDescriptor);
    }

    private ColumnDescriptor getLocalColumnDescriptor(String string, TableDescriptor tableDescriptor) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", string, tableDescriptor.getName());
        }
        return columnDescriptor;
    }

    @Override
    void validateAutoincrement(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n) throws StandardException {
        ColumnDescriptor columnDescriptor;
        if (this.kind == 5 || this.kind == 6) {
            ColumnDescriptor columnDescriptor2 = this.getLocalColumnDescriptor(this.name, tableDescriptor);
            if (!columnDescriptor2.isAutoincrement()) {
                throw StandardException.newException("42Z29", this.getColumnName());
            }
            if (this.kind == 6) {
                this.defaultInfo = ModifyColumnNode.createDefaultInfoOfAutoInc();
            }
            return;
        }
        if (this.kind == 2 && (columnDescriptor = this.getLocalColumnDescriptor(this.name, tableDescriptor)).isAutoincrement()) {
            throw StandardException.newException("42Z26", this.getColumnName());
        }
        if (this.autoincrementVerify && !(columnDescriptor = this.getLocalColumnDescriptor(this.name, tableDescriptor)).isAutoincrement()) {
            throw StandardException.newException("42837", tableDescriptor.getQualifiedName(), this.name);
        }
        if (!this.isAutoincrement) {
            return;
        }
        super.validateAutoincrement(dataDictionary, tableDescriptor, n);
        if (this.getType().isNullable()) {
            throw StandardException.newException("42Z27", this.getColumnName());
        }
    }
}

