/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonDeserialize(builder=Builder.class)
public class ContinuationTokenRequest {
    public static final String UNIQUE_JSON_PATH = "/username";
    private final String username;
    private final String clientName;
    private final String clientVersion;
    private final String deviceName;

    public static Builder builder() {
        return new Builder();
    }

    private ContinuationTokenRequest(String username, String clientName, String clientVersion, String deviceName) {
        this.username = username;
        this.clientName = clientName;
        this.clientVersion = clientVersion;
        this.deviceName = deviceName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private String username;
        private String clientName;
        private String clientVersion;
        private String deviceName;

        private Builder() {
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public Builder clientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public ContinuationTokenRequest build() {
            return new ContinuationTokenRequest(this.username, this.clientName, this.clientVersion, this.deviceName);
        }
    }
}

