/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.ldap.sdk.controls.MatchedValuesFilter;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MatchedValuesRequestControl
extends Control {
    @NotNull
    public static final String MATCHED_VALUES_REQUEST_OID = "1.2.826.0.1.3344810.2.3";
    @NotNull
    private static final String JSON_FIELD_FILTERS = "filters";
    private static final long serialVersionUID = 6799850686547208774L;
    @NotNull
    private final MatchedValuesFilter[] filters;

    public MatchedValuesRequestControl(MatchedValuesFilter ... filters) {
        this(false, filters);
    }

    public MatchedValuesRequestControl(@NotNull List<MatchedValuesFilter> filters) {
        this(false, filters);
    }

    public MatchedValuesRequestControl(boolean isCritical, MatchedValuesFilter ... filters) {
        super(MATCHED_VALUES_REQUEST_OID, isCritical, MatchedValuesRequestControl.encodeValue(filters));
        this.filters = filters;
    }

    public MatchedValuesRequestControl(boolean isCritical, @NotNull List<MatchedValuesFilter> filters) {
        this(isCritical, filters.toArray(new MatchedValuesFilter[filters.size()]));
    }

    public MatchedValuesRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] filterElements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.filters = new MatchedValuesFilter[filterElements.length];
            for (int i = 0; i < filterElements.length; ++i) {
                this.filters[i] = MatchedValuesFilter.decode(filterElements[i]);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_REQUEST_CANNOT_DECODE.get(e), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull MatchedValuesFilter[] filters) {
        Validator.ensureNotNull(filters);
        Validator.ensureTrue(filters.length > 0, "MatchedValuesRequestControl.filters must not be empty.");
        ASN1Element[] elements = new ASN1Element[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            elements[i] = filters[i].encode();
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public MatchedValuesFilter[] getFilters() {
        return this.filters;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_MATCHED_VALUES_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        ArrayList<JSONString> filterValues = new ArrayList<JSONString>(this.filters.length);
        for (MatchedValuesFilter filter : this.filters) {
            filterValues.add(new JSONString(filter.toString()));
        }
        return new JSONObject(new JSONField("oid", MATCHED_VALUES_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_MATCHED_VALUES_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_FILTERS, new JSONArray(filterValues)))));
    }

    @NotNull
    public static MatchedValuesRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new MatchedValuesRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        List<JSONValue> filterValues = valueObject.getFieldAsArray(JSON_FIELD_FILTERS);
        if (filterValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_REQUEST_JSON_NO_FILTERS.get(controlObject.toSingleLineString(), JSON_FIELD_FILTERS));
        }
        if (filterValues.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_REQUEST_JSON_EMPTY_FILTERS.get(controlObject.toSingleLineString(), JSON_FIELD_FILTERS));
        }
        ArrayList<MatchedValuesFilter> filters = new ArrayList<MatchedValuesFilter>(filterValues.size());
        for (JSONValue filterValue : filterValues) {
            if (filterValue instanceof JSONString) {
                String filterString = ((JSONString)filterValue).stringValue();
                try {
                    Filter filter = Filter.create(filterString);
                    filters.add(MatchedValuesFilter.create(filter));
                    continue;
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_REQUEST_JSON_INVALID_FILTER.get(controlObject.toSingleLineString(), JSON_FIELD_FILTERS, filterString, e.getMessage()), e);
                }
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_REQUEST_JSON_FILTER_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_FILTERS));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_FILTERS)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MV_REQUEST_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new MatchedValuesRequestControl(jsonControl.getCriticality(), filters);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("MatchedValuesRequestControl(filters={");
        for (int i = 0; i < this.filters.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('\'');
            this.filters[i].toString(buffer);
            buffer.append('\'');
        }
        buffer.append("}, isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

