/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.NodesRefresh;
import com.datastax.oss.driver.internal.core.metadata.TopologyEvent;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AddNodeRefresh
extends NodesRefresh {
    @VisibleForTesting
    final NodeInfo newNodeInfo;

    AddNodeRefresh(NodeInfo newNodeInfo) {
        this.newNodeInfo = newNodeInfo;
    }

    @Override
    public MetadataRefresh.Result compute(DefaultMetadata oldMetadata, boolean tokenMapEnabled, InternalDriverContext context) {
        Map<UUID, Node> oldNodes = oldMetadata.getNodes();
        Node existing = oldNodes.get(this.newNodeInfo.getHostId());
        if (existing == null) {
            DefaultNode newNode = new DefaultNode(this.newNodeInfo.getEndPoint(), context);
            AddNodeRefresh.copyInfos(this.newNodeInfo, newNode, context);
            ImmutableMap newNodes = ImmutableMap.builder().putAll(oldNodes).put((Object)newNode.getHostId(), (Object)newNode).build();
            return new MetadataRefresh.Result(oldMetadata.withNodes((Map<UUID, Node>)newNodes, tokenMapEnabled, false, null, context), (List<Object>)ImmutableList.of((Object)NodeStateEvent.added(newNode)));
        }
        if (!existing.getEndPoint().equals(this.newNodeInfo.getEndPoint())) {
            AddNodeRefresh.copyInfos(this.newNodeInfo, (DefaultNode)existing, context);
            assert (this.newNodeInfo.getBroadcastRpcAddress().isPresent());
            return new MetadataRefresh.Result(oldMetadata, (List<Object>)ImmutableList.of((Object)TopologyEvent.suggestUp(this.newNodeInfo.getBroadcastRpcAddress().get())));
        }
        return new MetadataRefresh.Result(oldMetadata);
    }
}

