/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

import java.util.ArrayList;
import java.util.List;
import org.nustaq.serialization.util.FSTUtil;

public class FSTIdentity2IdMap {
    private static final int RESERVE = 4;
    private static final int MAX_DEPTH = 4;
    static int[] prim = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 37, 67, 97, 139, 211, 331, 641, 1097, 1531, 2207, 3121, 5059, 7607, 10891, 15901, 19993, 30223, 50077, 74231, 99991, 150001, 300017, 1000033, 1500041, 200033, 3000077, 5000077, 10000019};
    private static final int GROFAC = 2;
    private int mask;
    public Object[] mKeys;
    private int klen;
    private int[] mValues;
    private int mNumberOfElements;
    private FSTIdentity2IdMap next;
    private List linearScanList;
    private List<Integer> linearScanVals;

    static int adjustSize(int size) {
        for (int i = 0; i < prim.length - 1; ++i) {
            if (size >= prim[i]) continue;
            return prim[i] + 4;
        }
        return size + 4;
    }

    public FSTIdentity2IdMap(int initialSize) {
        if (initialSize < 2) {
            initialSize = 2;
        }
        initialSize = FSTIdentity2IdMap.adjustSize(initialSize * 2);
        this.mKeys = new Object[initialSize];
        this.mValues = new int[initialSize];
        this.mNumberOfElements = 0;
        this.mask = (Integer.highestOneBit(initialSize) << 1) - 1;
        this.klen = initialSize - 4;
    }

    public int size() {
        if (this.linearScanList != null) {
            return this.linearScanList.size();
        }
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    public final int putOrGet(Object key, int value) {
        int hash = FSTIdentity2IdMap.calcHash(key);
        return this.putOrGetHash(key, value, hash, this, 0);
    }

    final int putOrGetHash(Object key, int value, int hash, FSTIdentity2IdMap parent, int depth) {
        int idx;
        Object[] mKeys;
        Object mKeyAtIdx;
        if (this.linearScanList != null) {
            for (int i = 0; i < this.linearScanList.size(); ++i) {
                Object o = this.linearScanList.get(i);
                if (o != key) continue;
                return this.linearScanVals.get(i);
            }
            this.linearScanList.add(key);
            this.linearScanVals.add(value);
            return Integer.MIN_VALUE;
        }
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            if (parent != null) {
                if ((parent.mNumberOfElements + this.mNumberOfElements) * 2 > parent.mKeys.length) {
                    parent.resize(parent.mKeys.length * 2);
                    return parent.putOrGet(key, value);
                }
                this.resize(this.mKeys.length * 2);
            } else {
                this.resize(this.mKeys.length * 2);
            }
        }
        if ((mKeyAtIdx = (mKeys = this.mKeys)[idx = this.calcIndexFromHash(hash, mKeys)]) == null) {
            ++this.mNumberOfElements;
            this.mValues[idx] = value;
            mKeys[idx] = key;
            return Integer.MIN_VALUE;
        }
        if (mKeyAtIdx == key) {
            return this.mValues[idx];
        }
        Object mKeyAtIdxPlus1 = mKeys[idx + 1];
        if (mKeyAtIdxPlus1 == null) {
            ++this.mNumberOfElements;
            this.mValues[idx + 1] = value;
            mKeys[idx + 1] = key;
            return Integer.MIN_VALUE;
        }
        if (mKeyAtIdxPlus1 == key) {
            return this.mValues[idx + 1];
        }
        Object mKeysAtIndexPlus2 = mKeys[idx + 2];
        if (mKeysAtIndexPlus2 == null) {
            ++this.mNumberOfElements;
            this.mValues[idx + 2] = value;
            mKeys[idx + 2] = key;
            return Integer.MIN_VALUE;
        }
        if (mKeysAtIndexPlus2 == key) {
            return this.mValues[idx + 2];
        }
        return this.putOrGetNext(hash, key, value, depth + 1);
    }

    final int putOrGetNext(int hash, Object key, int value, int depth) {
        if (this.next == null) {
            int newSiz = this.mKeys.length / 10;
            this.next = new FSTIdentity2IdMap(newSiz);
            if (depth > 4) {
                this.next.linearScanVals = new ArrayList<Integer>(3);
                this.next.linearScanList = new ArrayList(3);
            }
            this.next.putHash(key, value, hash, this, depth);
            return Integer.MIN_VALUE;
        }
        return this.next.putOrGetHash(key, value, hash, this, depth + 1);
    }

    public final void put(Object key, int value) {
        int hash = FSTIdentity2IdMap.calcHash(key);
        this.putHash(key, value, hash, this, 0);
    }

    final void putHash(Object key, int value, int hash, FSTIdentity2IdMap parent, int depth) {
        int idx;
        Object[] mKeys;
        if (this.linearScanList != null) {
            for (int i = 0; i < this.linearScanList.size(); ++i) {
                Object o = this.linearScanList.get(i);
                if (o != key) continue;
                this.linearScanVals.set(i, value);
                return;
            }
            this.linearScanList.add(key);
            this.linearScanVals.add(value);
            return;
        }
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            if (parent != null) {
                if ((parent.mNumberOfElements + this.mNumberOfElements) * 2 > parent.mKeys.length) {
                    parent.resize(parent.mKeys.length * 2);
                    parent.put(key, value);
                    return;
                }
                this.resize(this.mKeys.length * 2);
            } else {
                this.resize(this.mKeys.length * 2);
            }
        }
        if ((mKeys = this.mKeys)[idx = this.calcIndexFromHash(hash, mKeys)] == null) {
            ++this.mNumberOfElements;
            this.mValues[idx] = value;
            mKeys[idx] = key;
        } else if (mKeys[idx] == key) {
            this.mValues[idx] = value;
        } else if (mKeys[idx + 1] == null) {
            ++this.mNumberOfElements;
            this.mValues[idx + 1] = value;
            mKeys[idx + 1] = key;
        } else if (mKeys[idx + 1] == key) {
            this.mValues[idx + 1] = value;
        } else if (mKeys[idx + 2] == null) {
            ++this.mNumberOfElements;
            this.mValues[idx + 2] = value;
            mKeys[idx + 2] = key;
        } else if (mKeys[idx + 2] == key) {
            this.mValues[idx + 2] = value;
        } else {
            this.putNext(hash, key, value, depth + 1);
        }
    }

    final void putNext(int hash, Object key, int value, int depth) {
        if (this.next == null) {
            int newSiz = this.mKeys.length / 10;
            this.next = new FSTIdentity2IdMap(newSiz);
            if (depth > 4) {
                this.next.linearScanVals = new ArrayList<Integer>(3);
                this.next.linearScanList = new ArrayList(3);
            }
        }
        this.next.putHash(key, value, hash, this, depth + 1);
    }

    public final int get(Object key) {
        int hash = FSTIdentity2IdMap.calcHash(key);
        return this.getHash(key, hash);
    }

    final int getHash(Object key, int hash) {
        if (this.linearScanList != null) {
            for (int i = 0; i < this.linearScanList.size(); ++i) {
                Object o = this.linearScanList.get(i);
                if (o != key) continue;
                return this.linearScanVals.get(i);
            }
            return Integer.MIN_VALUE;
        }
        int idx = this.calcIndexFromHash(hash, this.mKeys);
        Object mapsKey = this.mKeys[idx];
        if (mapsKey == null) {
            return Integer.MIN_VALUE;
        }
        if (mapsKey == key) {
            return this.mValues[idx];
        }
        mapsKey = this.mKeys[idx + 1];
        if (mapsKey == null) {
            return Integer.MIN_VALUE;
        }
        if (mapsKey == key) {
            return this.mValues[idx + 1];
        }
        mapsKey = this.mKeys[idx + 2];
        if (mapsKey == null) {
            return Integer.MIN_VALUE;
        }
        if (mapsKey == key) {
            return this.mValues[idx + 2];
        }
        if (this.next == null) {
            return Integer.MIN_VALUE;
        }
        return this.next.getHash(key, hash);
    }

    final void resize(int newSize) {
        newSize = FSTIdentity2IdMap.adjustSize(newSize);
        Object[] oldTabKey = this.mKeys;
        int[] oldTabVal = this.mValues;
        this.mKeys = new Object[newSize];
        this.mValues = new int[newSize];
        this.mNumberOfElements = 0;
        this.mask = (Integer.highestOneBit(newSize) << 1) - 1;
        this.klen = newSize - 4;
        for (int n = 0; n < oldTabKey.length; ++n) {
            if (oldTabKey[n] == null) continue;
            this.put(oldTabKey[n], oldTabVal[n]);
        }
        if (this.next != null) {
            FSTIdentity2IdMap oldNext = this.next;
            this.next = null;
            oldNext.rePut(this);
        }
    }

    private void rePut(FSTIdentity2IdMap kfstObject2IntMap) {
        if (this.linearScanList != null) {
            int size = this.linearScanList.size();
            for (int i = 0; i < size; ++i) {
                Object key = this.linearScanList.get(i);
                int value = this.linearScanVals.get(i);
                kfstObject2IntMap.put(key, value);
            }
            return;
        }
        for (int i = 0; i < this.mKeys.length; ++i) {
            Object mKey = this.mKeys[i];
            if (mKey == null) continue;
            kfstObject2IntMap.put(mKey, this.mValues[i]);
        }
        if (this.next != null) {
            this.next.rePut(kfstObject2IntMap);
        }
    }

    final int calcIndexFromHash(int hash, Object[] mKeys) {
        int res;
        for (res = hash & this.mask; res >= this.klen; res >>>= 1) {
        }
        return res;
    }

    private static int calcHash(Object x) {
        int h2 = System.identityHashCode(x);
        return (h2 << 1) - (h2 << 8) & Integer.MAX_VALUE;
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        if (this.linearScanList != null) {
            this.linearScanList.clear();
            this.linearScanVals.clear();
        }
        FSTUtil.clear(this.mKeys);
        FSTUtil.clear(this.mValues);
        this.mNumberOfElements = 0;
        if (this.next != null) {
            this.next.clear();
        }
    }

    public void dump() {
        for (int i = 0; i < this.mKeys.length; ++i) {
            Object mKey = this.mKeys[i];
            if (mKey == null) continue;
            System.out.println("" + mKey + " => " + this.mValues[i]);
        }
        if (this.next != null) {
            this.next.dump();
        }
    }

    public int keysLength() {
        return this.mKeys.length;
    }
}

