/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.AuthenticateRequest;
import org.apache.james.imap.message.request.IRAuthenticateRequest;
import org.apache.james.imap.message.response.AuthenticateResponse;
import org.apache.james.imap.processor.AbstractAuthProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.jwt.OidcJwtTokenVerifier;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.OIDCSASLParser;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticateProcessor
extends AbstractAuthProcessor<AuthenticateRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticateProcessor.class);
    private static final String AUTH_TYPE_PLAIN = "PLAIN";
    private static final String AUTH_TYPE_OAUTHBEARER = "OAUTHBEARER";
    private static final String AUTH_TYPE_XOAUTH2 = "XOAUTH2";
    private static final List<Capability> OAUTH_CAPABILITIES = ImmutableList.of((Object)Capability.of("AUTH=OAUTHBEARER"), (Object)Capability.of("AUTH=XOAUTH2"));

    public AuthenticateProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(AuthenticateRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(AuthenticateRequest request, ImapSession session, ImapProcessor.Responder responder) {
        String authType = request.getAuthType();
        if (authType.equalsIgnoreCase(AUTH_TYPE_PLAIN)) {
            if (session.isPlainAuthDisallowed()) {
                this.no(request, responder, HumanReadableText.DISABLED_LOGIN);
            } else if (request instanceof IRAuthenticateRequest) {
                IRAuthenticateRequest irRequest = (IRAuthenticateRequest)request;
                this.doPlainAuth(irRequest.getInitialClientResponse(), session, request, responder);
            } else {
                responder.respond(new AuthenticateResponse());
                session.pushLineHandler((requestSession, data) -> {
                    this.doPlainAuth(AuthenticateProcessor.extractInitialClientResponse(data), requestSession, request, responder);
                    requestSession.popLineHandler();
                });
            }
        } else if (authType.equalsIgnoreCase(AUTH_TYPE_OAUTHBEARER) || authType.equalsIgnoreCase(AUTH_TYPE_XOAUTH2)) {
            if (request instanceof IRAuthenticateRequest) {
                IRAuthenticateRequest irRequest = (IRAuthenticateRequest)request;
                this.doOAuth(irRequest.getInitialClientResponse(), session, request, responder);
            } else {
                responder.respond(new AuthenticateResponse());
                session.pushLineHandler((requestSession, data) -> {
                    this.doOAuth(AuthenticateProcessor.extractInitialClientResponse(data), requestSession, request, responder);
                    requestSession.popLineHandler();
                });
            }
        } else {
            LOGGER.debug("Unsupported authentication mechanism '{}'", (Object)authType);
            this.no(request, responder, HumanReadableText.UNSUPPORTED_AUTHENTICATION_MECHANISM);
        }
    }

    protected void doPlainAuth(String initialClientResponse, ImapSession session, ImapRequest request, ImapProcessor.Responder responder) {
        AbstractAuthProcessor.AuthenticationAttempt authenticationAttempt = this.parseDelegationAttempt(initialClientResponse);
        if (authenticationAttempt.isDelegation()) {
            this.doAuthWithDelegation(authenticationAttempt, session, request, responder, HumanReadableText.AUTHENTICATION_FAILED);
        } else {
            this.doAuth(authenticationAttempt, session, request, responder, HumanReadableText.AUTHENTICATION_FAILED);
        }
        session.stopDetectingCommandInjection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractAuthProcessor.AuthenticationAttempt parseDelegationAttempt(String initialClientResponse) {
        String userpass = new String(Base64.getDecoder().decode(initialClientResponse));
        StringTokenizer authTokenizer = new StringTokenizer(userpass, "\u0000");
        String token1 = authTokenizer.nextToken();
        String token2 = authTokenizer.nextToken();
        try {
            AbstractAuthProcessor.AuthenticationAttempt authenticationAttempt = AuthenticateProcessor.delegation(Username.of((String)token1), Username.of((String)token2), authTokenizer.nextToken());
            authTokenizer = null;
            return authenticationAttempt;
        }
        catch (NoSuchElementException ignored) {
            try {
                AbstractAuthProcessor.AuthenticationAttempt authenticationAttempt = AuthenticateProcessor.noDelegation(Username.of((String)token1), token2);
                authTokenizer = null;
                return authenticationAttempt;
            }
            catch (Throwable throwable) {
                try {
                    authTokenizer = null;
                    throw throwable;
                }
                catch (Exception e) {
                    return AuthenticateProcessor.noDelegation(null, null);
                }
            }
        }
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        ArrayList<Capability> caps = new ArrayList<Capability>();
        if (!session.isPlainAuthDisallowed()) {
            caps.add(Capability.of("AUTH=PLAIN"));
        }
        caps.add(Capability.of("SASL-IR"));
        if (session.supportsOAuth()) {
            caps.addAll(OAUTH_CAPABILITIES);
        }
        return ImmutableList.copyOf(caps);
    }

    @Override
    protected Closeable addContextToMDC(AuthenticateRequest request) {
        return MDCBuilder.create().addToContext("action", "AUTHENTICATE").addToContext("authType", request.getAuthType()).build();
    }

    private void doOAuth(String initialResponse, ImapSession session, ImapRequest request, ImapProcessor.Responder responder) {
        if (!session.supportsOAuth()) {
            this.no(request, responder, HumanReadableText.UNSUPPORTED_AUTHENTICATION_MECHANISM);
        } else {
            OIDCSASLParser.parse((String)initialResponse).flatMap(oidcInitialResponseValue -> session.oidcSaslConfiguration().flatMap(configuration -> new OidcJwtTokenVerifier().verifyAndExtractClaim(oidcInitialResponseValue.getToken(), configuration.getJwksURL(), configuration.getClaim()))).flatMap(this::extractUserFromClaim).ifPresentOrElse(username -> this.authSuccess((Username)username, session, request, responder), () -> this.manageFailureCount(session, request, responder, HumanReadableText.AUTHENTICATION_FAILED));
        }
        session.stopDetectingCommandInjection();
    }

    private Optional<Username> extractUserFromClaim(String claimValue) {
        try {
            return Optional.of(Username.fromMailAddress((MailAddress)new MailAddress(claimValue)));
        }
        catch (AddressException e) {
            return Optional.empty();
        }
    }

    private static String extractInitialClientResponse(byte[] data) {
        return new String(data, 0, data.length - 2, StandardCharsets.US_ASCII);
    }
}

