/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.message.response.AbstractListingResponse;
import org.apache.james.mailbox.model.MailboxMetaData;

public class ListingEncodingUtils {
    public static void encodeListingResponse(ImapCommand command, ImapResponseComposer composer, AbstractListingResponse response) throws IOException {
        composer.untagged();
        composer.message(command.getName());
        composer.openParen();
        for (String attribute : ListingEncodingUtils.getNameAttributes(response)) {
            composer.message(attribute);
        }
        composer.closeParen();
        ListingEncodingUtils.writeDelimiter(composer, response.getHierarchyDelimiter());
        composer.mailbox(response.getName());
        composer.end();
    }

    private static void writeDelimiter(ImapResponseComposer composer, char hierarchyDelimiter) throws IOException {
        if (hierarchyDelimiter == '\u0000') {
            composer.nil();
        } else {
            composer.quote(Character.toString(hierarchyDelimiter));
        }
    }

    private static ImmutableList<String> getNameAttributes(AbstractListingResponse response) {
        return ImmutableList.builder().addAll(ListingEncodingUtils.selectabilityAsString(response.getSelectability())).addAll(ListingEncodingUtils.childrenAsString(response.getChildren())).addAll(ListingEncodingUtils.mailboxAttributeAsString(response.getType())).build();
    }

    private static List<String> selectabilityAsString(MailboxMetaData.Selectability selectability) {
        switch (selectability) {
            case MARKED: {
                return ImmutableList.of((Object)"\\Marked");
            }
            case NOSELECT: {
                return ImmutableList.of((Object)"\\Noselect");
            }
            case UNMARKED: {
                return ImmutableList.of((Object)"\\Unmarked");
            }
        }
        return ImmutableList.of();
    }

    private static ImmutableList<String> childrenAsString(MailboxMetaData.Children children) {
        switch (children) {
            case HAS_CHILDREN: {
                return ImmutableList.of((Object)"\\HasChildren");
            }
            case HAS_NO_CHILDREN: {
                return ImmutableList.of((Object)"\\HasNoChildren");
            }
            case NO_INFERIORS: {
                return ImmutableList.of((Object)"\\Noinferiors");
            }
        }
        return ImmutableList.of();
    }

    private static ImmutableList<String> mailboxAttributeAsString(MailboxType type) {
        String attributeName = type.getAttributeName();
        if (attributeName != null) {
            return ImmutableList.of((Object)attributeName);
        }
        return ImmutableList.of();
    }
}

