/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.lifecycle;

import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.PriorityOrdered;

public abstract class AbstractLifecycleBeanPostProcessor<T>
implements BeanPostProcessor,
PriorityOrdered,
BeanFactoryAware {
    private int order = Integer.MIN_VALUE;
    private ConfigurableListableBeanFactory factory;

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.factory = (ConfigurableListableBeanFactory)factory;
    }

    public final Object postProcessBeforeInitialization(Object bean, String name) throws BeansException {
        try {
            Class<T> lClass = this.getLifeCycleInterface();
            if (lClass.isInstance(bean) && this.factory.containsBeanDefinition(name)) {
                this.executeLifecycleMethodBeforeInit(bean, name);
            }
        }
        catch (Exception e) {
            throw new FatalBeanException("Unable to execute lifecycle method on bean" + name, (Throwable)e);
        }
        return bean;
    }

    public final Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
        try {
            Class<T> lClass = this.getLifeCycleInterface();
            if (lClass.isInstance(bean) && this.factory.containsBeanDefinition(name)) {
                this.executeLifecycleMethodAfterInit(bean, name);
            }
        }
        catch (Exception e) {
            throw new FatalBeanException("Unable to execute lifecycle method on bean" + name, (Throwable)e);
        }
        return bean;
    }

    protected abstract Class<T> getLifeCycleInterface();

    protected abstract void executeLifecycleMethodBeforeInit(T var1, String var2) throws Exception;

    protected abstract void executeLifecycleMethodAfterInit(T var1, String var2) throws Exception;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

