/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jpa.healthcheck;

import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import reactor.core.publisher.Mono;

public class JPAHealthCheck
implements HealthCheck {
    private final EntityManagerFactory entityManagerFactory;

    @Inject
    public JPAHealthCheck(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public ComponentName componentName() {
        return new ComponentName("JPA Backend");
    }

    public Mono<Result> check() {
        return Mono.fromCallable(() -> ((EntityManagerFactory)this.entityManagerFactory).createEntityManager()).map(entityManager -> entityManager.isOpen()).map(open -> {
            if (open.booleanValue()) {
                return Result.healthy((ComponentName)this.componentName());
            }
            return Result.unhealthy((ComponentName)this.componentName(), (String)"entityManager is not open");
        }).onErrorResume(IllegalStateException.class, e -> Mono.just((Object)Result.unhealthy((ComponentName)this.componentName(), (String)"EntityManagerFactory or EntityManager thrown an IllegalStateException, the connection is unhealthy", (Throwable)e)));
    }
}

