/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ArrayUtil;

public abstract class SpanWeight
extends Weight {
    protected final Similarity similarity;
    protected final Similarity.SimScorer simScorer;
    protected final String field;

    public SpanWeight(SpanQuery query, IndexSearcher searcher, Map<Term, TermStates> termStates, float boost) throws IOException {
        super(query);
        this.field = query.getField();
        this.similarity = searcher.getSimilarity();
        this.simScorer = this.buildSimWeight(query, searcher, termStates, boost);
    }

    private Similarity.SimScorer buildSimWeight(SpanQuery query, IndexSearcher searcher, Map<Term, TermStates> termStates, float boost) throws IOException {
        if (termStates == null || termStates.size() == 0 || query.getField() == null) {
            return null;
        }
        TermStatistics[] termStats = new TermStatistics[termStates.size()];
        int termUpTo = 0;
        for (Map.Entry<Term, TermStates> entry : termStates.entrySet()) {
            TermStates ts = entry.getValue();
            if (ts.docFreq() <= 0) continue;
            termStats[termUpTo++] = searcher.termStatistics(entry.getKey(), ts.docFreq(), ts.totalTermFreq());
        }
        CollectionStatistics collectionStats = searcher.collectionStatistics(query.getField());
        if (termUpTo > 0) {
            return this.similarity.scorer(boost, collectionStats, ArrayUtil.copyOfSubArray(termStats, 0, termUpTo));
        }
        return null;
    }

    public abstract void extractTermStates(Map<Term, TermStates> var1);

    public abstract Spans getSpans(LeafReaderContext var1, Postings var2) throws IOException;

    @Override
    public SpanScorer scorer(LeafReaderContext context) throws IOException {
        Spans spans = this.getSpans(context, Postings.POSITIONS);
        if (spans == null) {
            return null;
        }
        LeafSimScorer docScorer = this.getSimScorer(context);
        return new SpanScorer(this, spans, docScorer);
    }

    public LeafSimScorer getSimScorer(LeafReaderContext context) throws IOException {
        return this.simScorer == null ? null : new LeafSimScorer(this.simScorer, context.reader(), this.field, true);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        int newDoc;
        SpanScorer scorer = this.scorer(context);
        if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
            if (this.simScorer != null) {
                float freq = scorer.sloppyFreq();
                LeafSimScorer docScorer = new LeafSimScorer(this.simScorer, context.reader(), this.field, true);
                Explanation freqExplanation = Explanation.match((Number)Float.valueOf(freq), "phraseFreq=" + freq, new Explanation[0]);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
            }
            return Explanation.match((Number)Float.valueOf(0.0f), String.format(Locale.ROOT, "match %s in %s without score", this.getQuery(), doc), new Explanation[0]);
        }
        return Explanation.noMatch("no matching term", new Explanation[0]);
    }

    @Override
    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        return MatchesUtils.forField(this.field, () -> {
            final Spans spans = this.getSpans(context, Postings.OFFSETS);
            if (spans == null || spans.advance(doc) != doc) {
                return null;
            }
            return new MatchesIterator(){
                int innerTermCount = 0;
                TermMatch[] innerTerms = new TermMatch[0];
                SpanCollector termCollector = new SpanCollector(){

                    @Override
                    public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
                        ++innerTermCount;
                        if (innerTermCount > innerTerms.length) {
                            TermMatch[] temp = new TermMatch[innerTermCount];
                            System.arraycopy(innerTerms, 0, temp, 0, innerTermCount - 1);
                            innerTerms = temp;
                            innerTerms[innerTermCount - 1] = new TermMatch();
                        }
                        innerTerms[innerTermCount - 1].term = term;
                        innerTerms[innerTermCount - 1].position = position;
                        innerTerms[innerTermCount - 1].startOffset = postings.startOffset();
                        innerTerms[innerTermCount - 1].endOffset = postings.endOffset();
                    }

                    @Override
                    public void reset() {
                        innerTermCount = 0;
                    }
                };

                @Override
                public boolean next() throws IOException {
                    this.innerTermCount = 0;
                    return spans.nextStartPosition() != Integer.MAX_VALUE;
                }

                @Override
                public int startPosition() {
                    return spans.startPosition();
                }

                @Override
                public int endPosition() {
                    return spans.endPosition() - 1;
                }

                @Override
                public int startOffset() throws IOException {
                    if (this.innerTermCount == 0) {
                        this.collectInnerTerms();
                    }
                    return this.innerTerms[0].startOffset;
                }

                @Override
                public int endOffset() throws IOException {
                    if (this.innerTermCount == 0) {
                        this.collectInnerTerms();
                    }
                    return this.innerTerms[this.innerTermCount - 1].endOffset;
                }

                @Override
                public MatchesIterator getSubMatches() throws IOException {
                    if (this.innerTermCount == 0) {
                        this.collectInnerTerms();
                    }
                    return new MatchesIterator(){
                        int upto = -1;

                        @Override
                        public boolean next() throws IOException {
                            ++this.upto;
                            return this.upto < innerTermCount;
                        }

                        @Override
                        public int startPosition() {
                            return innerTerms[this.upto].position;
                        }

                        @Override
                        public int endPosition() {
                            return innerTerms[this.upto].position;
                        }

                        @Override
                        public int startOffset() throws IOException {
                            return innerTerms[this.upto].startOffset;
                        }

                        @Override
                        public int endOffset() throws IOException {
                            return innerTerms[this.upto].endOffset;
                        }

                        @Override
                        public MatchesIterator getSubMatches() throws IOException {
                            return null;
                        }

                        @Override
                        public Query getQuery() {
                            return new TermQuery(innerTerms[this.upto].term);
                        }
                    };
                }

                @Override
                public Query getQuery() {
                    return SpanWeight.this.getQuery();
                }

                void collectInnerTerms() throws IOException {
                    this.termCollector.reset();
                    spans.collect(this.termCollector);
                    Arrays.sort(this.innerTerms, 0, this.innerTermCount, Comparator.comparing(a -> a.position));
                }
            };
        });
    }

    private static class TermMatch {
        Term term;
        int position;
        int startOffset;
        int endOffset;

        private TermMatch() {
        }
    }

    public static enum Postings {
        POSITIONS{

            @Override
            public int getRequiredPostings() {
                return 24;
            }
        }
        ,
        PAYLOADS{

            @Override
            public int getRequiredPostings() {
                return 88;
            }
        }
        ,
        OFFSETS{

            @Override
            public int getRequiredPostings() {
                return 120;
            }
        };


        public abstract int getRequiredPostings();

        public Postings atLeast(Postings postings) {
            if (postings.compareTo(this) > 0) {
                return postings;
            }
            return this;
        }
    }
}

