/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ConnectionType;
import software.amazon.awssdk.services.glue.model.MatchCriteriaCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetConnectionsFilter> {
    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchCriteria").getter(GetConnectionsFilter.getter(GetConnectionsFilter::matchCriteria)).setter(GetConnectionsFilter.setter(Builder::matchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(GetConnectionsFilter.getter(GetConnectionsFilter::connectionTypeAsString)).setter(GetConnectionsFilter.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_CRITERIA_FIELD, CONNECTION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> matchCriteria;
    private final String connectionType;

    private GetConnectionsFilter(BuilderImpl builder) {
        this.matchCriteria = builder.matchCriteria;
        this.connectionType = builder.connectionType;
    }

    public final boolean hasMatchCriteria() {
        return this.matchCriteria != null && !(this.matchCriteria instanceof SdkAutoConstructList);
    }

    public final List<String> matchCriteria() {
        return this.matchCriteria;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchCriteria() ? this.matchCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionsFilter)) {
            return false;
        }
        GetConnectionsFilter other = (GetConnectionsFilter)obj;
        return this.hasMatchCriteria() == other.hasMatchCriteria() && Objects.equals(this.matchCriteria(), other.matchCriteria()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectionsFilter").add("MatchCriteria", this.hasMatchCriteria() ? this.matchCriteria() : null).add("ConnectionType", (Object)this.connectionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.matchCriteria()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionsFilter, T> g) {
        return obj -> g.apply((GetConnectionsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();
        private String connectionType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionsFilter model) {
            this.matchCriteria(model.matchCriteria);
            this.connectionType(model.connectionType);
        }

        public final Collection<String> getMatchCriteria() {
            if (this.matchCriteria instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchCriteria;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String ... matchCriteria) {
            this.matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public GetConnectionsFilter build() {
            return new GetConnectionsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetConnectionsFilter> {
        public Builder matchCriteria(Collection<String> var1);

        public Builder matchCriteria(String ... var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);
    }
}

