/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.spark.SparkDistributionAndOrderingUtil;
import org.apache.iceberg.spark.actions.SparkSizeBasedDataRewriter;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SortOrderUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.utils.DistributionAndOrderingUtils$;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.internal.SQLConf;

abstract class SparkShufflingDataRewriter
extends SparkSizeBasedDataRewriter {
    public static final String COMPRESSION_FACTOR = "compression-factor";
    public static final double COMPRESSION_FACTOR_DEFAULT = 1.0;
    private double compressionFactor;

    protected SparkShufflingDataRewriter(SparkSession spark, Table table) {
        super(spark, table);
    }

    protected abstract SortOrder sortOrder();

    protected Schema sortSchema() {
        return this.table().schema();
    }

    protected abstract Dataset<Row> sortedDF(Dataset<Row> var1, List<FileScanTask> var2);

    public Set<String> validOptions() {
        return ImmutableSet.builder().addAll((Iterable)super.validOptions()).add((Object)COMPRESSION_FACTOR).build();
    }

    public void init(Map<String, String> options) {
        super.init(options);
        this.compressionFactor = this.compressionFactor(options);
    }

    @Override
    public void doRewrite(String groupId, List<FileScanTask> group) {
        this.spark().conf().set(SQLConf.SHUFFLE_PARTITIONS().key(), this.numShufflePartitions(group));
        Dataset scanDF = this.spark().read().format("iceberg").option("scan-task-set-id", groupId).load(groupId);
        Dataset<Row> sortedDF = this.sortedDF((Dataset<Row>)scanDF, group);
        sortedDF.write().format("iceberg").option("rewritten-file-scan-task-set-id", groupId).option("target-file-size-bytes", this.writeMaxFileSize()).option("use-table-distribution-and-ordering", "false").option("output-spec-id", (long)this.outputSpecId()).mode("append").save(groupId);
    }

    protected Dataset<Row> sort(Dataset<Row> df, SortOrder sortOrder) {
        org.apache.spark.sql.connector.expressions.SortOrder[] ordering = SparkDistributionAndOrderingUtil.convert(sortOrder);
        OrderedDistribution distribution = Distributions.ordered((org.apache.spark.sql.connector.expressions.SortOrder[])ordering);
        SQLConf conf = this.spark().sessionState().conf();
        LogicalPlan plan = df.logicalPlan();
        LogicalPlan sortPlan = DistributionAndOrderingUtils$.MODULE$.prepareQuery((Distribution)distribution, ordering, plan, conf);
        return new Dataset(this.spark(), sortPlan, df.encoder());
    }

    protected SortOrder outputSortOrder(List<FileScanTask> group, SortOrder sortOrder) {
        boolean requiresRepartitioning;
        PartitionSpec spec = this.outputSpec();
        boolean bl = requiresRepartitioning = !group.get(0).spec().equals((Object)spec);
        if (requiresRepartitioning) {
            return SortOrderUtil.buildSortOrder((Schema)this.sortSchema(), (PartitionSpec)spec, (SortOrder)this.sortOrder());
        }
        return sortOrder;
    }

    private long numShufflePartitions(List<FileScanTask> group) {
        long numOutputFiles = this.numOutputFiles((long)((double)this.inputSize(group) * this.compressionFactor));
        return Math.max(1L, numOutputFiles);
    }

    private double compressionFactor(Map<String, String> options) {
        double value = PropertyUtil.propertyAsDouble(options, (String)COMPRESSION_FACTOR, (double)1.0);
        Preconditions.checkArgument((value > 0.0 ? 1 : 0) != 0, (String)"'%s' is set to %s but must be > 0", (Object)COMPRESSION_FACTOR, (Object)value);
        return value;
    }
}

