/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OperatorAttributes;
import org.apache.flink.streaming.api.operators.OperatorAttributesBuilder;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class PartitionReduceOperator<IN>
extends AbstractUdfStreamOperator<IN, ReduceFunction<IN>>
implements OneInputStreamOperator<IN, IN>,
BoundedOneInput {
    private final ReduceFunction<IN> reduceFunction;
    private IN currentRecord = null;

    public PartitionReduceOperator(ReduceFunction<IN> reduceFunction) {
        super(reduceFunction);
        this.reduceFunction = reduceFunction;
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        this.currentRecord = this.currentRecord == null ? element.getValue() : this.reduceFunction.reduce(this.currentRecord, element.getValue());
    }

    @Override
    public void endInput() throws Exception {
        this.output.collect(new StreamRecord<IN>(this.currentRecord));
    }

    @Override
    public OperatorAttributes getOperatorAttributes() {
        return new OperatorAttributesBuilder().setOutputOnlyAfterEndOfStream(true).build();
    }
}

