/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.vault;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.StringUtils;
import org.apache.ignite3.internal.vault.VaultEntry;
import org.apache.ignite3.internal.vault.VaultService;
import org.jetbrains.annotations.Nullable;

public class VaultManager
implements IgniteComponent {
    public static final ByteArray NODE_NAME = new ByteArray("node_name");
    private final VaultService vaultSvc;

    public VaultManager(VaultService vaultSvc) {
        this.vaultSvc = vaultSvc;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.vaultSvc.start();
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.vaultSvc.close();
        return CompletableFutures.nullCompletedFuture();
    }

    @Nullable
    public VaultEntry get(ByteArray key) {
        return this.vaultSvc.get(key);
    }

    public void put(ByteArray key, byte @Nullable [] val) {
        this.vaultSvc.put(key, val);
    }

    public void remove(ByteArray key) {
        this.vaultSvc.remove(key);
    }

    public Cursor<VaultEntry> range(ByteArray fromKey, ByteArray toKey) {
        return this.vaultSvc.range(fromKey, toKey);
    }

    public Cursor<VaultEntry> prefix(ByteArray prefix) {
        return this.vaultSvc.range(prefix, ByteArray.fromString(StringUtils.incrementLastChar(prefix.toString())));
    }

    public void putAll(Map<ByteArray, byte[]> vals) {
        this.vaultSvc.putAll(vals);
    }

    public void putName(String name) {
        if (name.isBlank()) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        this.put(NODE_NAME, name.getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    public String name() {
        VaultEntry nameEntry = this.vaultSvc.get(NODE_NAME);
        return nameEntry == null ? null : new String(nameEntry.value(), StandardCharsets.UTF_8);
    }
}

