/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.sorted.io;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.pagememory.io.IoVersions;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.tree.BplusTree;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.tree.io.BplusLeafIo;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.SortedIndexRow;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.SortedIndexRowKey;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.SortedIndexTree;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.io.SortedIndexTreeIo;

public class SortedIndexTreeLeafIo
extends BplusLeafIo<SortedIndexRowKey>
implements SortedIndexTreeIo {
    public static final List<IoVersions<SortedIndexTreeLeafIo>> VERSIONS = IntStream.rangeClosed(0, 2048).mapToObj(inlineSize -> new IoVersions((PageIo[])new SortedIndexTreeLeafIo[]{new SortedIndexTreeLeafIo(1, inlineSize)})).collect(Collectors.toUnmodifiableList());

    private SortedIndexTreeLeafIo(int ver, int inlineSize) {
        super(25000 + inlineSize, ver, 24 + inlineSize);
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BplusIo<SortedIndexRowKey> srcIo, long srcPageAddr, int srcIdx) {
        SortedIndexTreeIo.super.store(dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, SortedIndexRowKey row) {
        SortedIndexTreeIo.super.storeByOffset(pageAddr, off, row);
    }

    @Override
    public SortedIndexRowKey getLookupRow(BplusTree<SortedIndexRowKey, ?> tree, long pageAddr, int idx) throws IgniteInternalCheckedException {
        SortedIndexTree sortedIndexTree = (SortedIndexTree)tree;
        return this.getRow(sortedIndexTree.dataPageReader(), sortedIndexTree.partitionId(), pageAddr, idx);
    }

    @Override
    public void visit(BplusTree<SortedIndexRowKey, ?> tree, long pageAddr, Consumer<SortedIndexRowKey> c) {
        SortedIndexTree sortedIndexTree = (SortedIndexTree)tree;
        int count = this.getCount(pageAddr);
        for (int i = 0; i < count; ++i) {
            SortedIndexRow indexRow;
            try {
                indexRow = this.getRow(sortedIndexTree.dataPageReader(), sortedIndexTree.partitionId(), pageAddr, i);
            }
            catch (IgniteInternalCheckedException e) {
                throw new IgniteInternalException(e);
            }
            c.accept(indexRow);
        }
    }
}

