/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite3.internal.sql.engine.exec.PartitionProvider;
import org.apache.ignite3.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.apache.ignite3.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningColumns;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningPredicate;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;

public class DynamicPartitionProvider<RowT>
implements PartitionProvider<RowT> {
    private final String nodeName;
    private final Int2ObjectMap<NodeWithConsistencyToken> assignments;
    private final PartitionPruningColumns columns;
    private final IgniteTable table;

    public DynamicPartitionProvider(String nodeName, Int2ObjectMap<NodeWithConsistencyToken> assignments, PartitionPruningColumns columns, IgniteTable table) {
        this.nodeName = nodeName;
        this.assignments = assignments;
        this.columns = columns;
        this.table = table;
    }

    @Override
    public List<PartitionWithConsistencyToken> getPartitions(ExecutionContext<RowT> ctx) {
        ExpressionFactory<RowT> expressionFactory = ctx.expressionFactory();
        return PartitionPruningPredicate.prunePartitions(ctx, this.columns, this.table, expressionFactory, this.assignments, this.nodeName);
    }
}

