/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.metric;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.apache.ignite3.internal.tostring.S;

@Schema(description="A list of metric sources provided by modules.")
public class MetricSource {
    @Schema(description="Metric source name.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String name;
    @Schema(description="If True, the metric is tracked. Otherwise, the metric is not tracked.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final boolean enabled;

    @JsonCreator
    public MetricSource(@JsonProperty(value="name") String name, @JsonProperty(value="enabled") boolean enabled) {
        this.name = name;
        this.enabled = enabled;
    }

    @JsonGetter(value="name")
    public String name() {
        return this.name;
    }

    @JsonGetter(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricSource that = (MetricSource)o;
        return this.enabled == that.enabled && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Boolean.hashCode(this.enabled);
        return result;
    }

    public String toString() {
        return S.toString(this);
    }
}

