/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.configuration;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Produces;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.rest.api.Problem;

@Controller(value="/management/v1/configuration/node")
@Tag(name="nodeConfiguration")
public interface NodeConfigurationApi {
    @Operation(operationId="getNodeConfiguration", summary="Get node configuration", description="Gets node configuration in HOCON format.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Full node configuration.", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get
    public String getConfiguration();

    @Operation(operationId="getNodeConfigurationByPath", summary="Get configuration represented by path", description="Gets a configuration of a specific node, in HOCON format.")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}, description="Returned node configuration."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    @Get(value="/{path}")
    public String getConfigurationByPath(@PathVariable(value="path") @Parameter(required=true, description="Configuration tree address. For example: `element.subelement`.") String var1);

    @Operation(operationId="updateNodeConfiguration", summary="Update node configuration", description="Updates node configuration. New configuration should be provided in HOCON format.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Configuration successfully updated."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="405", description="Configuration is read-only.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="422", description="Configuration parse/apply error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"text/plain"})
    @Produces(value={"application/problem+json"})
    @Patch
    public CompletableFuture<Void> updateConfiguration(@Body @RequestBody(description="The node configuration to update.") String var1);
}

