/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network;

import java.util.UUID;
import org.apache.ignite3.network.ClusterNode;
import org.apache.ignite3.network.NetworkAddress;
import org.apache.ignite3.network.NodeMetadata;
import org.jetbrains.annotations.Nullable;

public class PublicClusterNodeImpl
implements ClusterNode {
    private final UUID id;
    private final String name;
    private final NetworkAddress address;
    @Nullable
    private final NodeMetadata nodeMetadata;

    public PublicClusterNodeImpl(UUID id, String name, NetworkAddress address, @Nullable NodeMetadata nodeMetadata) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.nodeMetadata = nodeMetadata;
    }

    public PublicClusterNodeImpl(UUID id, String name, NetworkAddress address) {
        this(id, name, address, null);
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public NetworkAddress address() {
        return this.address;
    }

    @Override
    @Nullable
    public NodeMetadata nodeMetadata() {
        return this.nodeMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicClusterNodeImpl that = (PublicClusterNodeImpl)o;
        return this.name.equals(that.name) && this.address.equals(that.address);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.address.hashCode();
        return result;
    }

    public String toString() {
        return String.format("{id=%s, name=%s, address=%s}", this.id, this.name, this.address);
    }
}

