/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.internal.compute.CancellableJobExecution;
import org.apache.ignite3.internal.compute.CancellableTaskExecution;
import org.apache.ignite3.internal.compute.JobTaskStatusMapper;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

class TaskToJobExecutionWrapper<R>
implements CancellableJobExecution<R> {
    private final CancellableTaskExecution<R> taskExecution;
    private final ClusterNode publicLocalNode;

    TaskToJobExecutionWrapper(CancellableTaskExecution<R> taskExecution, InternalClusterNode localNode) {
        this.taskExecution = taskExecution;
        this.publicLocalNode = localNode.toPublicNode();
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return this.taskExecution.resultAsync();
    }

    @Override
    public CompletableFuture<@Nullable JobState> stateAsync() {
        return this.taskExecution.stateAsync().thenApply(JobTaskStatusMapper::toJobState);
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        return this.taskExecution.cancelAsync();
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.taskExecution.changePriorityAsync(newPriority);
    }

    @Override
    public ClusterNode node() {
        return this.publicLocalNode;
    }
}

