/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.cluster.unit;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.call.cluster.unit.UndeployUnitCallInput;
import org.apache.ignite3.internal.cli.call.cluster.unit.UndeployUnitReplCall;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import picocli.CommandLine;

@CommandLine.Command(name="undeploy", description={"Undeploys a unit"})
public class ClusterUnitUndeployReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Parameters(index="0", description={"Unit id"})
    private String id;
    @CommandLine.Option(names={"--version"}, description={"Unit version (x.y.z)"}, required=true)
    private String version;
    @Inject
    private UndeployUnitReplCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(clusterUrl -> UndeployUnitCallInput.builder().id(this.id).version(this.version).clusterUrl((String)clusterUrl).build()).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot undeploy unit")).print());
    }
}

