/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.metrics.AtomicLongMetric;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointMetricSource;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointMetricsTracker;

class CheckpointMetrics {
    private final AtomicLongMetric lastLockWaitDuration;
    private final AtomicLongMetric lastLockHoldDuration;
    private final AtomicLongMetric lastPagesWriteDuration;
    private final AtomicLongMetric lastFsyncDuration;
    private final AtomicLongMetric lastBeforeLockDuration;
    private final AtomicLongMetric lastReplicatorLogSyncDuration;
    private final AtomicLongMetric lastSplitAndSortCheckpointPagesDuration;
    private final AtomicLongMetric lastWaitPageReplacementDuration;
    private final AtomicLongMetric lastCheckpointDuration;
    private final AtomicLongMetric lastTotalPagesNumber;

    CheckpointMetrics(CheckpointMetricSource source) {
        this.lastLockWaitDuration = source.addMetric(new AtomicLongMetric("LastCheckpointLockWaitDuration", "Duration of the last checkpoint lock wait in milliseconds."));
        this.lastLockHoldDuration = source.addMetric(new AtomicLongMetric("LastCheckpointLockHoldDuration", "Duration of the last checkpoint lock hold in milliseconds."));
        this.lastBeforeLockDuration = source.addMetric(new AtomicLongMetric("LastCheckpointBeforeLockDuration", "Duration of actions before hold lock by the last checkpoint in milliseconds."));
        this.lastPagesWriteDuration = source.addMetric(new AtomicLongMetric("LastCheckpointPagesWriteDuration", "Duration of the last checkpoint pages write in milliseconds."));
        this.lastFsyncDuration = source.addMetric(new AtomicLongMetric("LastCheckpointFsyncDuration", "Duration of the sync phase of the last checkpoint in milliseconds."));
        this.lastReplicatorLogSyncDuration = source.addMetric(new AtomicLongMetric("LastCheckpointReplicatorLogSyncDuration", "Duration of the replicator log sync phase of the last checkpoint in milliseconds."));
        this.lastSplitAndSortCheckpointPagesDuration = source.addMetric(new AtomicLongMetric("LastCheckpointSplitAndSortPagesDuration", "Duration of the split and sort dirty pages phase of the last checkpoint in milliseconds."));
        this.lastWaitPageReplacementDuration = source.addMetric(new AtomicLongMetric("LastCheckpointWaitPageReplacementDuration", "Duration of the wait page replacement phase of the last checkpoint in milliseconds."));
        this.lastCheckpointDuration = source.addMetric(new AtomicLongMetric("LastCheckpointDuration", "Duration of the last checkpoint in milliseconds."));
        this.lastTotalPagesNumber = source.addMetric(new AtomicLongMetric("LastCheckpointTotalPagesNumber", "Total number of pages written during the last checkpoint."));
    }

    void update(CheckpointMetricsTracker tracker, long totalPages) {
        this.lastLockWaitDuration.value(tracker.writeLockWaitDuration(TimeUnit.MILLISECONDS));
        this.lastLockHoldDuration.value(tracker.writeLockHoldDuration(TimeUnit.MILLISECONDS));
        this.lastBeforeLockDuration.value(tracker.beforeWriteLockDuration(TimeUnit.MILLISECONDS));
        this.lastPagesWriteDuration.value(tracker.pagesWriteDuration(TimeUnit.MILLISECONDS));
        this.lastFsyncDuration.value(tracker.fsyncDuration(TimeUnit.MILLISECONDS));
        this.lastReplicatorLogSyncDuration.value(tracker.replicatorLogSyncDuration(TimeUnit.MILLISECONDS));
        this.lastSplitAndSortCheckpointPagesDuration.value(tracker.splitAndSortCheckpointPagesDuration(TimeUnit.MILLISECONDS));
        this.lastWaitPageReplacementDuration.value(tracker.waitPageReplacementDuration(TimeUnit.MILLISECONDS));
        this.lastCheckpointDuration.value(tracker.checkpointDuration(TimeUnit.MILLISECONDS));
        this.lastTotalPagesNumber.value(totalPages);
    }
}

