/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.errors;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DistinctErrors {
    private final List<DistinctObservation> distinctObservations = new ArrayList<DistinctObservation>();
    private final long evictionInterval;

    public DistinctErrors() {
        this(null);
    }

    public DistinctErrors(Duration evictionInterval) {
        this.evictionInterval = evictionInterval != null && evictionInterval.toMillis() > 0L ? evictionInterval.toMillis() : Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Throwable observation) {
        DistinctErrors distinctErrors = this;
        synchronized (distinctErrors) {
            long now = System.currentTimeMillis();
            DistinctObservation distinctObservation = DistinctErrors.find(now, this.distinctObservations, observation);
            if (distinctObservation == null) {
                this.distinctObservations.add(new DistinctObservation(observation, now + this.evictionInterval));
                return false;
            }
            if (distinctObservation.deadline > now) {
                distinctObservation.resetDeadline(now + this.evictionInterval);
                return false;
            }
        }
        return true;
    }

    private static DistinctObservation find(long now, List<DistinctObservation> existingObservations, Throwable observation) {
        int lastIndex;
        DistinctObservation existingObservation = null;
        for (int i = lastIndex = existingObservations.size() - 1; i >= 0; --i) {
            DistinctObservation o = existingObservations.get(lastIndex);
            if (DistinctErrors.equals(o.throwable, observation)) {
                existingObservation = o;
                break;
            }
            if (o.deadline <= now) continue;
            if (i == lastIndex) {
                existingObservations.remove(i);
            } else {
                existingObservations.set(i, existingObservations.remove(lastIndex));
            }
            --lastIndex;
        }
        return existingObservation;
    }

    private static boolean equals(Throwable lhs, Throwable rhs) {
        do {
            if (lhs == rhs) {
                return true;
            }
            if (lhs.getClass() != rhs.getClass() || !Objects.equals(lhs.getMessage(), rhs.getMessage()) || !DistinctErrors.equals(lhs.getStackTrace(), rhs.getStackTrace())) break;
            lhs = lhs.getCause();
            rhs = rhs.getCause();
            if (null != lhs || null != rhs) continue;
            return true;
        } while (null != lhs && null != rhs);
        return false;
    }

    private static boolean equals(StackTraceElement[] lhsStackTrace, StackTraceElement[] rhsStackTrace) {
        if (lhsStackTrace.length != rhsStackTrace.length) {
            return false;
        }
        int length = lhsStackTrace.length;
        for (int i = 0; i < length; ++i) {
            StackTraceElement lhs = lhsStackTrace[i];
            StackTraceElement rhs = rhsStackTrace[i];
            if (lhs.getLineNumber() == rhs.getLineNumber() && lhs.getClassName().equals(rhs.getClassName()) && Objects.equals(lhs.getMethodName(), rhs.getMethodName()) && Objects.equals(lhs.getFileName(), rhs.getFileName())) continue;
            return false;
        }
        return true;
    }

    private static final class DistinctObservation {
        private final Throwable throwable;
        private long deadline;

        DistinctObservation(Throwable throwable, long deadline) {
            this.throwable = throwable;
            this.deadline = deadline;
        }

        void resetDeadline(long deadline) {
            this.deadline = deadline;
        }
    }
}

