/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.lookup;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.schema.lookup.Lookup;
import org.apache.calcite.schema.lookup.Named;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LoadingCacheLookup<T>
implements Lookup<T> {
    private final Lookup<T> delegate;
    private final LoadingCache<String, T> cache;
    private final LoadingCache<String, Named<T>> cacheIgnoreCase;

    public LoadingCacheLookup(Lookup<T> delegate, Duration expiration) {
        this.delegate = delegate;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(expiration.toMillis(), TimeUnit.MILLISECONDS).build(CacheLoader.from(name -> Objects.requireNonNull(delegate.get((String)name))));
        this.cacheIgnoreCase = CacheBuilder.newBuilder().expireAfterWrite(expiration.toMillis(), TimeUnit.MILLISECONDS).build(CacheLoader.from(name -> Objects.requireNonNull(delegate.getIgnoreCase((String)name))));
    }

    public LoadingCacheLookup(Lookup<T> delegate) {
        this(delegate, Duration.ofMinutes(1L));
    }

    @Override
    public @Nullable T get(String name) {
        try {
            return (T)this.cache.get((Object)name);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof NullPointerException) {
                return null;
            }
            throw e;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public @Nullable Named<T> getIgnoreCase(String name) {
        try {
            return (Named)this.cacheIgnoreCase.get((Object)name);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof NullPointerException) {
                return null;
            }
            throw e;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> getNames(LikePattern pattern) {
        return this.delegate.getNames(pattern);
    }
}

