/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.table.PublicApiThreadingViewBase;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingKeyValueView<K, V>
extends PublicApiThreadingViewBase<Map.Entry<K, V>>
implements KeyValueView<K, V> {
    private final KeyValueView<K, V> view;

    public PublicApiThreadingKeyValueView(KeyValueView<K, V> view, Executor asyncContinuationExecutor) {
        super(view, view, asyncContinuationExecutor);
        this.view = view;
    }

    @Nullable
    public V get(@Nullable Transaction tx, K key) {
        return (V)PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.get(tx, key));
    }

    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        return this.executeAsyncOp(() -> this.view.getAsync(tx, key));
    }

    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.getNullable(tx, key));
    }

    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        return this.executeAsyncOp(() -> this.view.getNullableAsync(tx, key));
    }

    @Nullable
    public V getOrDefault(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        return (V)PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.getOrDefault(tx, key, defaultValue));
    }

    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        return this.executeAsyncOp(() -> this.view.getOrDefaultAsync(tx, key, defaultValue));
    }

    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.getAll(tx, keys));
    }

    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.executeAsyncOp(() -> this.view.getAllAsync(tx, keys));
    }

    public boolean contains(@Nullable Transaction tx, K key) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.contains(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        return this.executeAsyncOp(() -> this.view.containsAsync(tx, key));
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.containsAll(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.executeAsyncOp(() -> this.view.containsAllAsync(tx, keys));
    }

    public void put(@Nullable Transaction tx, K key, @Nullable V val) {
        PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.put(tx, key, val));
    }

    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.executeAsyncOp(() -> this.view.putAsync(tx, key, val));
    }

    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.putAll(tx, pairs));
    }

    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        return this.executeAsyncOp(() -> this.view.putAllAsync(tx, pairs));
    }

    @Nullable
    public V getAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return (V)PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.getAndPut(tx, key, val));
    }

    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.executeAsyncOp(() -> this.view.getAndPutAsync(tx, key, val));
    }

    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.getNullableAndPut(tx, key, val));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.executeAsyncOp(() -> this.view.getNullableAndPutAsync(tx, key, val));
    }

    public boolean putIfAbsent(@Nullable Transaction tx, K key, @Nullable V val) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.putIfAbsent(tx, key, val));
    }

    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.executeAsyncOp(() -> this.view.putIfAbsentAsync(tx, key, val));
    }

    public boolean remove(@Nullable Transaction tx, K key) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.remove(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, K key, V val) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.remove(tx, key, val));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        return this.executeAsyncOp(() -> this.view.removeAsync(tx, key));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, V val) {
        return this.executeAsyncOp(() -> this.view.removeAsync(tx, key, val));
    }

    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.removeAll(tx, keys));
    }

    public void removeAll(@Nullable Transaction tx) {
        PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.removeAll(tx));
    }

    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.executeAsyncOp(() -> this.view.removeAllAsync(tx, keys));
    }

    public CompletableFuture<Void> removeAllAsync(@Nullable Transaction tx) {
        return this.executeAsyncOp(() -> this.view.removeAllAsync(tx));
    }

    @Nullable
    public V getAndRemove(@Nullable Transaction tx, K key) {
        return (V)PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.getAndRemove(tx, key));
    }

    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        return this.executeAsyncOp(() -> this.view.getAndRemoveAsync(tx, key));
    }

    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.getNullableAndRemove(tx, key));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        return this.executeAsyncOp(() -> this.view.getNullableAndRemoveAsync(tx, key));
    }

    public boolean replace(@Nullable Transaction tx, K key, @Nullable V val) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.replace(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, K key, V oldValue, @Nullable V newValue) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.replace(tx, key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.executeAsyncOp(() -> this.view.replaceAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V oldVal, @Nullable V newVal) {
        return this.executeAsyncOp(() -> this.view.replaceAsync(tx, key, oldVal, newVal));
    }

    @Nullable
    public V getAndReplace(@Nullable Transaction tx, @Nullable K key, @Nullable V val) {
        return (V)PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.getAndReplace(tx, key, val));
    }

    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.executeAsyncOp(() -> this.view.getAndReplaceAsync(tx, key, val));
    }

    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        return PublicApiThreadingKeyValueView.executeSyncOp(() -> this.view.getNullableAndReplace(tx, key, val));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.executeAsyncOp(() -> this.view.getNullableAndReplaceAsync(tx, key, val));
    }
}

