/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partitiondistribution;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsChainSerializer;
import org.apache.ignite.internal.partitiondistribution.AssignmentsLink;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AssignmentsChain
implements Iterable<AssignmentsLink> {
    @IgniteToStringInclude
    private final List<AssignmentsLink> chain;

    private AssignmentsChain(List<AssignmentsLink> chain) {
        assert (!chain.isEmpty()) : "Chain should not be empty";
        this.chain = chain;
    }

    public int size() {
        return this.chain.size();
    }

    public AssignmentsLink replaceLast(Assignments newLast, long configurationTerm, long configurationIndex) {
        assert (!this.chain.isEmpty()) : "Assignments chain is empty.";
        AssignmentsLink link = new AssignmentsLink(newLast, configurationTerm, configurationIndex);
        this.chain.set(this.chain.size() - 1, link);
        if (this.chain.size() > 1) {
            this.chain.get(this.chain.size() - 2).next(link);
        }
        return link;
    }

    public AssignmentsLink addLast(Assignments newLast, long configurationTerm, long configurationIndex) {
        assert (!this.chain.isEmpty()) : "Assignments chain is empty.";
        AssignmentsLink link = new AssignmentsLink(newLast, configurationTerm, configurationIndex);
        this.chain.get(this.chain.size() - 1).next(link);
        this.chain.add(link);
        return link;
    }

    public AssignmentsLink firstLink() {
        return this.chain.get(0);
    }

    @Nullable
    public AssignmentsLink lastLink(String nodeConsistentId) {
        for (int i = this.chain.size() - 1; i >= 0; --i) {
            AssignmentsLink link = this.chain.get(i);
            if (!link.hasNode(nodeConsistentId)) continue;
            return link;
        }
        return null;
    }

    @TestOnly
    public static AssignmentsChain of(Assignments ... assignments) {
        return AssignmentsChain.of(-1L, -1L, assignments);
    }

    public static AssignmentsChain of(long configurationTerm, long configurationIndex, Assignments ... assignments) {
        return AssignmentsChain.of(Stream.of(assignments).map(assignment -> new AssignmentsLink((Assignments)assignment, configurationTerm, configurationIndex)).collect(Collectors.toList()));
    }

    static AssignmentsChain of(List<AssignmentsLink> assignmentsChain) {
        for (int i = 1; i < assignmentsChain.size(); ++i) {
            assignmentsChain.get(i - 1).next(assignmentsChain.get(i));
        }
        return new AssignmentsChain(assignmentsChain);
    }

    public byte[] toBytes() {
        return VersionedSerialization.toBytes((Object)this, (VersionedSerializer)AssignmentsChainSerializer.INSTANCE);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static AssignmentsChain fromBytes(byte @Nullable [] bytes) {
        return bytes == null ? null : (AssignmentsChain)VersionedSerialization.fromBytes((byte[])bytes, (VersionedSerializer)AssignmentsChainSerializer.INSTANCE);
    }

    public String toString() {
        return S.toString((Object)this);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignmentsChain that = (AssignmentsChain)o;
        return Objects.equals(this.chain, that.chain);
    }

    public int hashCode() {
        return this.chain.hashCode();
    }

    @Override
    public Iterator<AssignmentsLink> iterator() {
        return this.chain.iterator();
    }
}

