/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.NewZoneEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;

public class NewZoneEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class NewZoneEntrySerializerV2
    implements CatalogObjectSerializer<NewZoneEntry> {
        NewZoneEntrySerializerV2() {
        }

        @Override
        public NewZoneEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogZoneDescriptor descriptor = input.readEntry(CatalogZoneDescriptor.class);
            return new NewZoneEntry(descriptor);
        }

        @Override
        public void writeTo(NewZoneEntry object, CatalogObjectDataOutput output) throws IOException {
            output.writeEntry(object.descriptor());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class NewZoneEntrySerializerV1
    implements CatalogObjectSerializer<NewZoneEntry> {
        private final CatalogEntrySerializerProvider serializers;

        public NewZoneEntrySerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public NewZoneEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_ZONE.id());
            CatalogZoneDescriptor descriptor = (CatalogZoneDescriptor)serializer.readFrom(input);
            return new NewZoneEntry(descriptor);
        }

        @Override
        public void writeTo(NewZoneEntry object, CatalogObjectDataOutput output) throws IOException {
            this.serializers.get(1, object.descriptor().typeId()).writeTo(object.descriptor(), output);
        }
    }
}

