/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.TimestampAwareReplicaResponse;
import org.apache.ignite.internal.replicator.message.TimestampAwareReplicaResponseBuilder;

class TimestampAwareReplicaResponseDeserializer
implements MessageDeserializer<TimestampAwareReplicaResponse> {
    private final TimestampAwareReplicaResponseBuilder msg;

    TimestampAwareReplicaResponseDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.timestampAwareReplicaResponse();
    }

    public Class<TimestampAwareReplicaResponse> klass() {
        return TimestampAwareReplicaResponse.class;
    }

    public TimestampAwareReplicaResponse getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readByteArray("resultByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.resultByteArray((byte[])tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TimestampAwareReplicaResponse.class);
    }
}

