/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.ReplicaSafeTimeSyncRequest;
import org.apache.ignite.internal.replicator.message.ReplicaSafeTimeSyncRequestBuilder;
import org.apache.ignite.internal.replicator.message.ReplicaSafeTimeSyncRequestSerializer;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ReplicaSafeTimeSyncRequestImpl
implements ReplicaSafeTimeSyncRequest,
Cloneable {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 5;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;

    private ReplicaSafeTimeSyncRequestImpl(ReplicationGroupIdMessage groupId) {
        this.groupId = groupId;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    public MessageSerializer serializer() {
        return ReplicaSafeTimeSyncRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(ReplicaSafeTimeSyncRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReplicaSafeTimeSyncRequestImpl otherMessage = (ReplicaSafeTimeSyncRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId);
        return result;
    }

    public ReplicaSafeTimeSyncRequestImpl clone() {
        try {
            return (ReplicaSafeTimeSyncRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReplicaSafeTimeSyncRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ReplicaSafeTimeSyncRequestBuilder {
        private ReplicationGroupIdMessage groupId;

        private Builder() {
        }

        @Override
        public ReplicaSafeTimeSyncRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public ReplicaSafeTimeSyncRequest build() {
            return new ReplicaSafeTimeSyncRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"));
        }
    }
}

