/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.computer.core.common.exception.TransportException;
import org.apache.hugegraph.computer.core.network.ClientFactory;
import org.apache.hugegraph.computer.core.network.ClientHandler;
import org.apache.hugegraph.computer.core.network.ConnectionId;
import org.apache.hugegraph.computer.core.network.TransportClient;
import org.apache.hugegraph.computer.core.network.TransportConf;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.computer.core.network.netty.BufAllocatorFactory;
import org.apache.hugegraph.computer.core.network.netty.NettyEventLoopUtil;
import org.apache.hugegraph.computer.core.network.netty.NettyProtocol;
import org.apache.hugegraph.computer.core.network.netty.NettyTransportClient;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class NettyClientFactory
implements ClientFactory {
    private static final Logger LOG = Log.logger(NettyClientFactory.class);
    private final TransportConf conf;
    private final ByteBufAllocator bufAllocator;
    private final NettyProtocol protocol;
    private EventLoopGroup workerGroup;
    private Bootstrap bootstrap;
    private int connectTimeoutMs;

    public NettyClientFactory(TransportConf conf) {
        this(conf, BufAllocatorFactory.createBufAllocator());
    }

    public NettyClientFactory(TransportConf conf, ByteBufAllocator bufAllocator) {
        this.conf = conf;
        this.bufAllocator = bufAllocator;
        this.protocol = new NettyProtocol(this.conf);
    }

    @Override
    public synchronized void init() {
        E.checkArgument((this.bootstrap == null ? 1 : 0) != 0, (String)"The NettyClientFactory has already been initialized", (Object[])new Object[0]);
        this.connectTimeoutMs = Math.toIntExact(this.conf.clientConnectionTimeout());
        this.workerGroup = NettyEventLoopUtil.createEventLoop(this.conf.ioMode(), this.conf.clientThreads(), "transport-netty-client");
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(this.workerGroup);
        this.bootstrap.channel(NettyEventLoopUtil.clientChannelClass(this.conf.ioMode()));
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)this.bufAllocator);
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.conf.tcpKeepAlive());
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeoutMs);
        if (this.conf.sizeReceiveBuffer() > 0) {
            this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.conf.sizeReceiveBuffer());
        }
        if (this.conf.sizeSendBuffer() > 0) {
            this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.conf.sizeSendBuffer());
        }
        WriteBufferWaterMark bufferWaterMark = new WriteBufferWaterMark(this.conf.writeBufferLowMark(), this.conf.writeBufferHighMark());
        this.bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)bufferWaterMark);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) {
                NettyClientFactory.this.protocol.initializeClientPipeline((Channel)channel);
            }
        });
    }

    @Override
    public TransportClient createClient(ConnectionId connectionId, ClientHandler handler) throws TransportException {
        InetSocketAddress address = connectionId.socketAddress();
        LOG.debug("Creating new client connection to '{}'", (Object)connectionId);
        Channel channel = this.doConnectWithRetries(address, this.conf.networkRetries(), this.connectTimeoutMs);
        NettyTransportClient client = new NettyTransportClient(channel, connectionId, this, handler);
        LOG.debug("Successfully created a new client to '{}'", (Object)connectionId);
        return client;
    }

    protected Channel doConnect(InetSocketAddress address, int connectTimeoutMs) throws TransportException {
        E.checkArgumentNotNull((Object)this.bootstrap, (String)"The NettyClientFactory has not been initialized yet", (Object[])new Object[0]);
        long preConnect = System.nanoTime();
        String formatAddress = TransportUtil.formatAddress(address);
        LOG.debug("ConnectTimeout of address [{}] is [{}]", (Object)formatAddress, (Object)connectTimeoutMs);
        ChannelFuture future = this.bootstrap.connect((SocketAddress)address);
        boolean success = future.awaitUninterruptibly((long)connectTimeoutMs, TimeUnit.MILLISECONDS);
        if (!future.isDone()) {
            throw new TransportException("Create connection to '%s' timeout!", formatAddress);
        }
        if (future.isCancelled()) {
            throw new TransportException("Create connection to '%s' cancelled by user!", formatAddress);
        }
        if (future.cause() != null) {
            throw new TransportException("Failed to create connection to '%s', caused by: %s", future.cause(), formatAddress, future.cause().getMessage());
        }
        if (!success || !future.isSuccess()) {
            throw new TransportException("Failed to create connection to '%s'", formatAddress);
        }
        long postConnect = System.nanoTime();
        LOG.info("Successfully created connection to '{}' after {} ms", (Object)formatAddress, (Object)((postConnect - preConnect) / 1000000L));
        return future.channel();
    }

    protected Channel doConnectWithRetries(InetSocketAddress address, int retryNumber, int connectTimeoutMs) throws TransportException {
        String formatAddress = TransportUtil.formatAddress(address);
        int tried = 0;
        while (true) {
            try {
                return this.doConnect(address, connectTimeoutMs);
            }
            catch (IOException e) {
                if (++tried > retryNumber) {
                    LOG.warn("Failed to connect to '{}', Giving up after {} retries", new Object[]{formatAddress, retryNumber, e});
                    throw e;
                }
                LOG.debug("Failed to connect to '{}' with retries times {}, Retrying...", new Object[]{formatAddress, tried, e});
                continue;
            }
            break;
        }
    }

    public TransportConf conf() {
        return this.conf;
    }

    protected NettyProtocol protocol() {
        return this.protocol;
    }

    @Override
    public void close() {
        if (this.workerGroup != null && !this.workerGroup.isShuttingDown()) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
        this.bootstrap = null;
    }
}

