/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input;

import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.input.GraphFetcher;
import org.apache.hugegraph.computer.core.input.InputSplitFetcher;
import org.apache.hugegraph.computer.core.input.hg.HugeGraphFetcher;
import org.apache.hugegraph.computer.core.input.hg.HugeInputSplitFetcher;
import org.apache.hugegraph.computer.core.input.loader.LoaderFileInputSplitFetcher;
import org.apache.hugegraph.computer.core.input.loader.LoaderGraphFetcher;
import org.apache.hugegraph.computer.core.rpc.InputSplitRpcService;
import org.apache.hugegraph.config.TypedOption;

public class InputSourceFactory {
    public static InputSplitFetcher createInputSplitFetcher(Config config) {
        String type;
        switch (type = (String)config.get((TypedOption)ComputerOptions.INPUT_SOURCE_TYPE)) {
            case "hugegraph-server": {
                return new HugeInputSplitFetcher(config);
            }
            case "hugegraph-loader": {
                return new LoaderFileInputSplitFetcher(config);
            }
        }
        throw new ComputerException("Unexpected source type %s", new Object[]{type});
    }

    public static GraphFetcher createGraphFetcher(Config config, InputSplitRpcService srv) {
        String type;
        switch (type = (String)config.get((TypedOption)ComputerOptions.INPUT_SOURCE_TYPE)) {
            case "hugegraph-server": {
                return new HugeGraphFetcher(config, srv);
            }
            case "hugegraph-loader": {
                return new LoaderGraphFetcher(config, srv);
            }
        }
        throw new ComputerException("Unexpected source type %s", new Object[]{type});
    }
}

