/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingIOSessionListener
implements IOSessionListener {
    public static final LoggingIOSessionListener INSTANCE = new LoggingIOSessionListener();
    private final Logger connLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.connection");

    @Internal
    public LoggingIOSessionListener() {
    }

    public void connected(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug("{} connected", (Object)session);
        }
    }

    public void startTls(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug("{} TLS started", (Object)session);
        }
    }

    public void inputReady(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug("{} input ready", (Object)session);
        }
    }

    public void outputReady(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug("{} output ready", (Object)session);
        }
    }

    public void timeout(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug("{} timeout", (Object)session);
        }
    }

    public void exception(IOSession session, Exception ex) {
        if (ex instanceof ConnectionClosedException) {
            return;
        }
        this.connLog.error("{} {}", new Object[]{session, ex.getMessage(), ex});
    }

    public void disconnected(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug("{} disconnected", (Object)session);
        }
    }
}

