/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.tsdb.vm;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hertzbeat.common.entity.arrow.RowWrapper;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.timer.HashedWheelTimer;
import org.apache.hertzbeat.common.timer.Timeout;
import org.apache.hertzbeat.common.timer.TimerTask;
import org.apache.hertzbeat.common.util.Base64Util;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.TimePeriodUtil;
import org.apache.hertzbeat.warehouse.store.history.tsdb.AbstractHistoryDataStorage;
import org.apache.hertzbeat.warehouse.store.history.tsdb.vm.PromQlQueryContent;
import org.apache.hertzbeat.warehouse.store.history.tsdb.vm.VictoriaMetricsClusterProperties;
import org.apache.hertzbeat.warehouse.store.history.tsdb.vm.VictoriaMetricsDataStorage;
import org.apache.hertzbeat.warehouse.store.history.tsdb.vm.VictoriaMetricsInsertProperties;
import org.apache.hertzbeat.warehouse.store.history.tsdb.vm.VictoriaMetricsSelectProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Primary
@Component
@ConditionalOnProperty(prefix="warehouse.store.victoria-metrics.cluster", name={"enabled"}, havingValue="true")
public class VictoriaMetricsClusterDataStorage
extends AbstractHistoryDataStorage {
    private static final Logger log = LoggerFactory.getLogger(VictoriaMetricsClusterDataStorage.class);
    private static final String VM_INSERT_BASE_PATH = "/insert/%s/%s";
    private static final String VM_SELECT_BASE_PATH = "/select/%s/%s";
    private static final String IMPORT_PATH = "prometheus/api/v1/import";
    private static final String EXPORT_PATH = "prometheus/api/v1/export";
    private static final String STATUS_PATH = "prometheus/api/v1/status/tsdb";
    private static final String STATUS_SUCCESS = "success";
    private static final String QUERY_RANGE_PATH = "prometheus/api/v1/query_range";
    private static final String LABEL_KEY_NAME = "__name__";
    private static final String LABEL_KEY_JOB = "job";
    private static final String LABEL_KEY_INSTANCE = "instance";
    private static final String LABEL_KEY_MONITOR_ID = "__monitor_id__";
    private static final String SPILT = "_";
    private static final String MONITOR_METRICS_KEY = "__metrics__";
    private static final String MONITOR_METRIC_KEY = "__metric__";
    private static final long MAX_WAIT_MS = 500L;
    private static final int MAX_RETRIES = 3;
    private final VictoriaMetricsClusterProperties vmClusterProps;
    private final VictoriaMetricsInsertProperties vmInsertProps;
    private final VictoriaMetricsSelectProperties vmSelectProps;
    private final RestTemplate restTemplate;
    private final BlockingQueue<VictoriaMetricsDataStorage.VictoriaMetricsContent> metricsBufferQueue;
    private HashedWheelTimer metricsFlushTimer = null;
    private MetricsFlushTask metricsFlushtask = null;
    private boolean isBatchImportEnabled = false;

    public VictoriaMetricsClusterDataStorage(VictoriaMetricsClusterProperties vmClusterProps, RestTemplate restTemplate) {
        if (vmClusterProps == null) {
            log.error("init error, please config Warehouse victoriaMetrics cluster props in application.yml");
            throw new IllegalArgumentException("please config Warehouse victoriaMetrics cluster props");
        }
        this.restTemplate = restTemplate;
        this.vmClusterProps = vmClusterProps;
        this.vmInsertProps = vmClusterProps.insert();
        this.vmSelectProps = vmClusterProps.select();
        this.serverAvailable = this.checkVictoriaMetricsDatasourceAvailable();
        this.metricsBufferQueue = new LinkedBlockingQueue<VictoriaMetricsDataStorage.VictoriaMetricsContent>(this.vmInsertProps.bufferSize());
        boolean bl = this.isBatchImportEnabled = this.vmInsertProps.flushInterval() != 0 && this.vmInsertProps.bufferSize() != 0;
        if (this.isBatchImportEnabled) {
            this.initializeFlushTimer();
        }
    }

    private void initializeFlushTimer() {
        this.metricsFlushTimer = new HashedWheelTimer(r -> {
            Thread thread = new Thread(r, "victoria-metrics-flush-timer");
            thread.setDaemon(true);
            return thread;
        }, 1L, TimeUnit.SECONDS, 512);
        this.metricsFlushtask = new MetricsFlushTask();
        this.metricsFlushTimer.newTimeout((TimerTask)this.metricsFlushtask, 0L, TimeUnit.SECONDS);
    }

    private boolean checkVictoriaMetricsDatasourceAvailable() {
        try {
            HttpEntity requestEntity;
            ResponseEntity responseEntity;
            String result;
            JsonNode jsonNode;
            String selectNodeStatusUrl = this.vmClusterProps.select().url() + VM_SELECT_BASE_PATH.formatted(this.vmClusterProps.accountID(), STATUS_PATH);
            HttpHeaders headers = new HttpHeaders();
            if (StringUtils.hasText((String)this.vmInsertProps.username()) && StringUtils.hasText((String)this.vmInsertProps.password())) {
                String authStr = this.vmInsertProps.username() + ":" + this.vmInsertProps.password();
                String encodedAuth = Base64Util.encode((String)authStr);
                headers.add("Authorization", "Basic " + encodedAuth);
            }
            if ((jsonNode = JsonUtil.fromJson((String)(result = (String)(responseEntity = this.restTemplate.exchange(selectNodeStatusUrl, HttpMethod.GET, requestEntity = new HttpEntity((MultiValueMap)headers), String.class, new Object[0])).getBody()))) != null && STATUS_SUCCESS.equalsIgnoreCase(jsonNode.get("status").asText())) {
                return true;
            }
            log.error("check victoria metrics cluster server status not success: {}.", (Object)result);
        }
        catch (Exception e) {
            log.error("check victoria metrics cluster server status error: {}.", (Object)e.getMessage());
        }
        return false;
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        boolean isPrometheusAuto;
        if (!this.isServerAvailable()) {
            this.serverAvailable = this.checkVictoriaMetricsDatasourceAvailable();
        }
        if (!this.isServerAvailable() || metricsData.getCode() != CollectRep.Code.SUCCESS) {
            return;
        }
        if (metricsData.getValues().isEmpty()) {
            log.info("[warehouse victoria-metrics] flush metrics data {} {} {} is null, ignore.", new Object[]{metricsData.getId(), metricsData.getApp(), metricsData.getMetrics()});
            return;
        }
        HashMap defaultLabels = Maps.newHashMapWithExpectedSize((int)8);
        defaultLabels.put(MONITOR_METRICS_KEY, metricsData.getMetrics());
        if (metricsData.getApp().startsWith("_prometheus_")) {
            isPrometheusAuto = true;
            defaultLabels.remove(MONITOR_METRICS_KEY);
            defaultLabels.put(LABEL_KEY_JOB, metricsData.getApp().substring("_prometheus_".length()));
        } else {
            isPrometheusAuto = false;
            defaultLabels.put(LABEL_KEY_JOB, metricsData.getApp());
        }
        defaultLabels.put(LABEL_KEY_INSTANCE, metricsData.getInstance());
        try {
            List fieldList = metricsData.getFields();
            Long[] timestamp = new Long[]{metricsData.getTime()};
            HashMap fieldsValue = Maps.newHashMapWithExpectedSize((int)fieldList.size());
            HashMap labels = Maps.newHashMapWithExpectedSize((int)fieldList.size());
            LinkedList<VictoriaMetricsDataStorage.VictoriaMetricsContent> contentList = new LinkedList<VictoriaMetricsDataStorage.VictoriaMetricsContent>();
            RowWrapper rowWrapper = metricsData.readRow();
            while (rowWrapper.hasNextRow()) {
                rowWrapper = rowWrapper.nextRow();
                fieldsValue.clear();
                labels.clear();
                rowWrapper.cellStream().forEach(cell -> {
                    String value = cell.getValue();
                    Byte type = cell.getMetadataAsByte("type");
                    Boolean label = cell.getMetadataAsBoolean("label");
                    if (type == 0 && !label.booleanValue() && !"&nbsp;".equals(value)) {
                        fieldsValue.put(cell.getField().getName(), CommonUtil.parseStrDouble((String)value));
                    }
                    if (label.booleanValue() && !"&nbsp;".equals(value)) {
                        labels.put(cell.getField().getName(), value);
                    }
                    for (Map.Entry entry : fieldsValue.entrySet()) {
                        if (entry.getKey() == null || entry.getValue() == null) continue;
                        try {
                            labels.putAll(defaultLabels);
                            String labelName = isPrometheusAuto ? metricsData.getMetrics() : metricsData.getMetrics() + SPILT + (String)entry.getKey();
                            labels.put(LABEL_KEY_NAME, labelName);
                            if (!isPrometheusAuto) {
                                labels.put(MONITOR_METRIC_KEY, (String)entry.getKey());
                            }
                            labels.put(LABEL_KEY_MONITOR_ID, String.valueOf(metricsData.getId()));
                            Map customizedLabels = metricsData.getLabels();
                            if (!ObjectUtils.isEmpty((Object)customizedLabels)) {
                                labels.putAll(customizedLabels);
                            }
                            VictoriaMetricsDataStorage.VictoriaMetricsContent content = VictoriaMetricsDataStorage.VictoriaMetricsContent.builder().metric(new HashMap<String, String>(labels)).values(new Double[]{(Double)entry.getValue()}).timestamps(timestamp).build();
                            contentList.add(content);
                        }
                        catch (Exception e) {
                            log.error("combine metrics data error: {}.", (Object)e.getMessage(), (Object)e);
                        }
                    }
                });
            }
            if (contentList.isEmpty()) {
                log.info("[warehouse victoria-metrics] flush metrics data {} is empty, ignore.", (Object)metricsData.getId());
                return;
            }
            if (!this.isBatchImportEnabled) {
                this.doSaveData(contentList);
                return;
            }
            this.sendVictoriaMetrics(contentList);
        }
        catch (Exception e) {
            log.error("flush metrics data to victoria-metrics error: {}.", (Object)e.getMessage(), (Object)e);
        }
    }

    public void destroy() {
        if (this.metricsFlushTimer != null && !this.metricsFlushTimer.isStop()) {
            this.metricsFlushTimer.stop();
        }
    }

    @Override
    public Map<String, List<Value>> getHistoryMetricData(String instance, String app, String metrics, String metric, String history) {
        Object labelName = metrics + SPILT + metric;
        if (app.startsWith("_prometheus_")) {
            labelName = metrics;
        }
        String timeSeriesSelector = Stream.of("__name__=\"" + (String)labelName + "\"", "instance=\"" + instance + "\"", app.startsWith("_prometheus_") ? null : "__metric__=\"" + metric + "\"").filter(Objects::nonNull).collect(Collectors.joining(","));
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(8);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            if (StringUtils.hasText((String)this.vmSelectProps.username()) && StringUtils.hasText((String)this.vmSelectProps.password())) {
                String authStr = this.vmSelectProps.username() + ":" + this.vmSelectProps.password();
                String encodedAuth = Base64Util.encode((String)authStr);
                headers.add("Authorization", "Basic " + encodedAuth);
            }
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            String exportUrl = this.vmClusterProps.select().url() + VM_SELECT_BASE_PATH.formatted(this.vmClusterProps.accountID(), EXPORT_PATH);
            URI uri = UriComponentsBuilder.fromUriString((String)exportUrl).queryParam("match[]", new Object[]{"{" + timeSeriesSelector + "}"}).queryParam("start", new Object[]{"now-" + history}).queryParam("end", new Object[]{"now"}).build().encode().toUri();
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, String.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.debug("query metrics data from victoria-metrics success. {}", (Object)uri);
                if (StringUtils.hasText((String)((String)responseEntity.getBody()))) {
                    String[] contentJsonArr = ((String)responseEntity.getBody()).split("\n");
                    List<VictoriaMetricsContent> contents = Arrays.stream(contentJsonArr).map(item -> (VictoriaMetricsContent)JsonUtil.fromJson((String)item, VictoriaMetricsContent.class)).toList();
                    for (VictoriaMetricsContent content : contents) {
                        Map<String, String> labels = content.getMetric();
                        labels.remove(LABEL_KEY_NAME);
                        labels.remove(LABEL_KEY_JOB);
                        labels.remove(LABEL_KEY_MONITOR_ID);
                        labels.remove(LABEL_KEY_INSTANCE);
                        labels.remove(MONITOR_METRICS_KEY);
                        labels.remove(MONITOR_METRIC_KEY);
                        String labelStr = JsonUtil.toJson(labels);
                        if (content.getValues() == null || content.getTimestamps() == null) continue;
                        List valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList());
                        if (content.getValues().length != content.getTimestamps().length) {
                            log.error("content.getValues().length != content.getTimestamps().length");
                            continue;
                        }
                        Double[] values = content.getValues();
                        Long[] timestamps = content.getTimestamps();
                        for (int index = 0; index < content.getValues().length; ++index) {
                            String strValue = BigDecimal.valueOf(values[index]).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                            valueList.add(new Value(strValue, timestamps[index].longValue()));
                        }
                    }
                }
            } else {
                log.error("query metrics data from victoria-metrics failed. {}", (Object)responseEntity);
            }
        }
        catch (Exception e) {
            log.error("query metrics data from victoria-metrics error. {}.", (Object)e.getMessage(), (Object)e);
        }
        return instanceValuesMap;
    }

    @Override
    public Map<String, List<Value>> getHistoryIntervalMetricData(String instance, String app, String metrics, String metric, String history) {
        ZonedDateTime dateTime;
        long startTime;
        if (!this.serverAvailable) {
            log.error("\n\t---------------VictoriaMetrics Init Failed---------------\n\t--------------Please Config VictoriaMetrics--------------\n\t----------Can Not Use Metric History Now----------\n");
            return Collections.emptyMap();
        }
        long endTime = ZonedDateTime.now().toEpochSecond();
        try {
            if (NumberUtils.isParsable((String)history)) {
                startTime = NumberUtils.toLong((String)history);
                startTime = ZonedDateTime.now().toEpochSecond() - startTime;
            } else {
                TemporalAmount temporalAmount = TimePeriodUtil.parseTokenTime((String)history);
                dateTime = ZonedDateTime.now().minus(temporalAmount);
                startTime = dateTime.toEpochSecond();
            }
        }
        catch (Exception e) {
            log.error("history time error: {}. use default: 6h", (Object)e.getMessage());
            dateTime = ZonedDateTime.now().minus(Duration.ofHours(6L));
            startTime = dateTime.toEpochSecond();
        }
        Object labelName = metrics + SPILT + metric;
        if (app.startsWith("_prometheus_")) {
            labelName = metrics;
        }
        String timeSeriesSelector = Stream.of("__name__=\"" + (String)labelName + "\"", "instance=\"" + instance + "\"", app.startsWith("_prometheus_") ? null : "__metric__=\"" + metric + "\"").filter(Objects::nonNull).collect(Collectors.joining(","));
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(8);
        try {
            Value value;
            List valueList;
            String labelStr;
            Map<String, String> labels;
            List<PromQlQueryContent.ContentData.Content> contents;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            if (StringUtils.hasText((String)this.vmSelectProps.username()) && StringUtils.hasText((String)this.vmSelectProps.password())) {
                String authStr = this.vmSelectProps.username() + ":" + this.vmSelectProps.password();
                String encodedAuth = Base64Util.encode((String)authStr);
                headers.add("Authorization", "Basic " + encodedAuth);
            }
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            String rangeUrl = this.vmClusterProps.select().url() + VM_SELECT_BASE_PATH.formatted(this.vmClusterProps.accountID(), QUERY_RANGE_PATH);
            URI uri = UriComponentsBuilder.fromUriString((String)rangeUrl).queryParam("query", new Object[]{"{" + timeSeriesSelector + "}"}).queryParam("step", new Object[]{"4h"}).queryParam("start", new Object[]{startTime}).queryParam("end", new Object[]{endTime}).build().encode().toUri();
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, PromQlQueryContent.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.debug("query metrics data from victoria-metrics success. {}", (Object)uri);
                if (responseEntity.getBody() != null && ((PromQlQueryContent)responseEntity.getBody()).getData() != null && ((PromQlQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                    contents = ((PromQlQueryContent)responseEntity.getBody()).getData().getResult();
                    for (PromQlQueryContent.ContentData.Content content : contents) {
                        labels = content.getMetric();
                        labels.remove(LABEL_KEY_NAME);
                        labels.remove(LABEL_KEY_JOB);
                        labels.remove(LABEL_KEY_INSTANCE);
                        labels.remove(LABEL_KEY_MONITOR_ID);
                        labels.remove(MONITOR_METRICS_KEY);
                        labels.remove(MONITOR_METRIC_KEY);
                        labelStr = JsonUtil.toJson(labels);
                        if (content.getValues() == null || content.getValues().isEmpty()) continue;
                        valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList());
                        for (Object[] valueArr : content.getValues()) {
                            long timestamp = Long.parseLong(String.valueOf(valueArr[0]));
                            String value2 = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                            valueList.add(new Value(value2, timestamp * 1000L));
                        }
                    }
                }
            } else {
                log.error("query metrics data from victoria-metrics failed. {}", (Object)responseEntity);
            }
            if ((responseEntity = this.restTemplate.exchange(uri = UriComponentsBuilder.fromUriString((String)rangeUrl).queryParam("query", new Object[]{"max_over_time({" + timeSeriesSelector + "})"}).queryParam("step", new Object[]{"4h"}).queryParam("start", new Object[]{startTime}).queryParam("end", new Object[]{endTime}).build().encode().toUri(), HttpMethod.GET, httpEntity, PromQlQueryContent.class)).getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null && ((PromQlQueryContent)responseEntity.getBody()).getData() != null && ((PromQlQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                contents = ((PromQlQueryContent)responseEntity.getBody()).getData().getResult();
                for (PromQlQueryContent.ContentData.Content content : contents) {
                    labels = content.getMetric();
                    labels.remove(LABEL_KEY_NAME);
                    labels.remove(LABEL_KEY_JOB);
                    labels.remove(LABEL_KEY_INSTANCE);
                    labels.remove(LABEL_KEY_MONITOR_ID);
                    labels.remove(MONITOR_METRICS_KEY);
                    labels.remove(MONITOR_METRIC_KEY);
                    labelStr = JsonUtil.toJson(labels);
                    if (content.getValues() == null || content.getValues().isEmpty() || (valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList())).size() != content.getValues().size()) continue;
                    for (int timestampIndex = 0; timestampIndex < valueList.size(); ++timestampIndex) {
                        value = (Value)valueList.get(timestampIndex);
                        Object[] valueArr = content.getValues().get(timestampIndex);
                        String maxValue = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                        value.setMax(maxValue);
                    }
                }
            }
            if ((responseEntity = this.restTemplate.exchange(uri = UriComponentsBuilder.fromUriString((String)rangeUrl).queryParam("query", new Object[]{"min_over_time({" + timeSeriesSelector + "})"}).queryParam("step", new Object[]{"4h"}).queryParam("start", new Object[]{startTime}).queryParam("end", new Object[]{endTime}).build().encode().toUri(), HttpMethod.GET, httpEntity, PromQlQueryContent.class)).getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null && ((PromQlQueryContent)responseEntity.getBody()).getData() != null && ((PromQlQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                contents = ((PromQlQueryContent)responseEntity.getBody()).getData().getResult();
                for (PromQlQueryContent.ContentData.Content content : contents) {
                    labels = content.getMetric();
                    labels.remove(LABEL_KEY_NAME);
                    labels.remove(LABEL_KEY_JOB);
                    labels.remove(LABEL_KEY_INSTANCE);
                    labels.remove(LABEL_KEY_MONITOR_ID);
                    labels.remove(MONITOR_METRICS_KEY);
                    labels.remove(MONITOR_METRIC_KEY);
                    labelStr = JsonUtil.toJson(labels);
                    if (content.getValues() == null || content.getValues().isEmpty() || (valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList())).size() != content.getValues().size()) continue;
                    for (int timestampIndex = 0; timestampIndex < valueList.size(); ++timestampIndex) {
                        value = (Value)valueList.get(timestampIndex);
                        Object[] valueArr = content.getValues().get(timestampIndex);
                        String minValue = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                        value.setMin(minValue);
                    }
                }
            }
            if ((responseEntity = this.restTemplate.exchange(uri = UriComponentsBuilder.fromUriString((String)rangeUrl).queryParam("query", new Object[]{"avg_over_time({" + timeSeriesSelector + "})"}).queryParam("step", new Object[]{"4h"}).queryParam("start", new Object[]{startTime}).queryParam("end", new Object[]{endTime}).build().encode().toUri(), HttpMethod.GET, httpEntity, PromQlQueryContent.class)).getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null && ((PromQlQueryContent)responseEntity.getBody()).getData() != null && ((PromQlQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                contents = ((PromQlQueryContent)responseEntity.getBody()).getData().getResult();
                for (PromQlQueryContent.ContentData.Content content : contents) {
                    labels = content.getMetric();
                    labels.remove(LABEL_KEY_NAME);
                    labels.remove(LABEL_KEY_JOB);
                    labels.remove(LABEL_KEY_INSTANCE);
                    labels.remove(LABEL_KEY_MONITOR_ID);
                    labels.remove(MONITOR_METRICS_KEY);
                    labels.remove(MONITOR_METRIC_KEY);
                    labelStr = JsonUtil.toJson(labels);
                    if (content.getValues() == null || content.getValues().isEmpty() || (valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList())).size() != content.getValues().size()) continue;
                    for (int timestampIndex = 0; timestampIndex < valueList.size(); ++timestampIndex) {
                        value = (Value)valueList.get(timestampIndex);
                        Object[] valueArr = content.getValues().get(timestampIndex);
                        String avgValue = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                        value.setMean(avgValue);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("query metrics data from victoria-metrics error. {}.", (Object)e.getMessage(), (Object)e);
        }
        return instanceValuesMap;
    }

    public void doSaveData(List<VictoriaMetricsDataStorage.VictoriaMetricsContent> contentList) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            if (StringUtils.hasText((String)this.vmInsertProps.username()) && StringUtils.hasText((String)this.vmInsertProps.password())) {
                String authStr = this.vmInsertProps.username() + ":" + this.vmInsertProps.password();
                String encodedAuth = Base64Util.encode((String)authStr);
                headers.add("Authorization", "Basic " + (String)encodedAuth);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (VictoriaMetricsDataStorage.VictoriaMetricsContent content : contentList) {
                stringBuilder.append(JsonUtil.toJson((Object)content)).append("\n");
            }
            HttpEntity httpEntity = new HttpEntity((Object)stringBuilder.toString(), (MultiValueMap)headers);
            String importUrl = this.vmClusterProps.insert().url() + VM_INSERT_BASE_PATH.formatted(this.vmClusterProps.accountID(), IMPORT_PATH);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(importUrl, (Object)httpEntity, String.class, new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.debug("insert metrics data to victoria-metrics success.");
            } else {
                log.error("insert metrics data to victoria-metrics failed. {}", responseEntity.getBody());
            }
        }
        catch (Exception e) {
            log.error("flush metrics data to victoria-metrics error: {}.", (Object)e.getMessage(), (Object)e);
        }
    }

    private void sendVictoriaMetrics(List<VictoriaMetricsDataStorage.VictoriaMetricsContent> contentList) {
        for (VictoriaMetricsDataStorage.VictoriaMetricsContent content : contentList) {
            boolean offered = false;
            int retryCount = 0;
            while (!offered && retryCount < 3) {
                try {
                    offered = this.metricsBufferQueue.offer(content, 500L, TimeUnit.MILLISECONDS);
                    if (offered) continue;
                    if (retryCount == 0) {
                        log.debug("victoria metrics buffer queue is full, triggering immediate flush");
                        this.triggerImmediateFlush();
                    }
                    if (++retryCount >= 3) continue;
                    Thread.sleep(100L * (long)retryCount);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("[Victoria Metrics] Interrupted while offering metrics to buffer queue", (Throwable)e);
                    break;
                }
            }
            if (!offered) {
                log.warn("[Victoria Metrics] Failed to add metrics to buffer after {} retries, saving directly", (Object)3);
                try {
                    this.doSaveData(contentList);
                }
                catch (Exception e) {
                    log.error("[Victoria Metrics] Failed to save metrics directly: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (!((double)this.metricsBufferQueue.size() >= (double)this.vmInsertProps.bufferSize() * 0.8)) continue;
            this.triggerImmediateFlush();
        }
    }

    private void triggerImmediateFlush() {
        this.metricsFlushTimer.newTimeout((TimerTask)this.metricsFlushtask, 0L, TimeUnit.MILLISECONDS);
    }

    private class MetricsFlushTask
    implements TimerTask {
        private MetricsFlushTask() {
        }

        public void run(Timeout timeout) {
            try {
                ArrayList<VictoriaMetricsDataStorage.VictoriaMetricsContent> batch = new ArrayList<VictoriaMetricsDataStorage.VictoriaMetricsContent>(VictoriaMetricsClusterDataStorage.this.vmInsertProps.bufferSize());
                VictoriaMetricsClusterDataStorage.this.metricsBufferQueue.drainTo(batch, VictoriaMetricsClusterDataStorage.this.vmInsertProps.bufferSize());
                if (!batch.isEmpty()) {
                    VictoriaMetricsClusterDataStorage.this.doSaveData(batch);
                    log.debug("[Victoria Metrics] Flushed {} metrics items", (Object)batch.size());
                }
                if (VictoriaMetricsClusterDataStorage.this.metricsFlushTimer != null && !VictoriaMetricsClusterDataStorage.this.metricsFlushTimer.isStop()) {
                    VictoriaMetricsClusterDataStorage.this.metricsFlushTimer.newTimeout((TimerTask)this, (long)VictoriaMetricsClusterDataStorage.this.vmInsertProps.flushInterval(), TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                log.error("[VictoriaMetrics] flush task error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static final class VictoriaMetricsContent {
        private Map<String, String> metric;
        private Double[] values;
        private Long[] timestamps;

        public static VictoriaMetricsContentBuilder builder() {
            return new VictoriaMetricsContentBuilder();
        }

        public Map<String, String> getMetric() {
            return this.metric;
        }

        public Double[] getValues() {
            return this.values;
        }

        public Long[] getTimestamps() {
            return this.timestamps;
        }

        public void setMetric(Map<String, String> metric) {
            this.metric = metric;
        }

        public void setValues(Double[] values) {
            this.values = values;
        }

        public void setTimestamps(Long[] timestamps) {
            this.timestamps = timestamps;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VictoriaMetricsContent)) {
                return false;
            }
            VictoriaMetricsContent other = (VictoriaMetricsContent)o;
            Map<String, String> this$metric = this.getMetric();
            Map<String, String> other$metric = other.getMetric();
            if (this$metric == null ? other$metric != null : !((Object)this$metric).equals(other$metric)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getValues(), other.getValues())) {
                return false;
            }
            return Arrays.deepEquals(this.getTimestamps(), other.getTimestamps());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $metric = this.getMetric();
            result = result * 59 + ($metric == null ? 43 : ((Object)$metric).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getValues());
            result = result * 59 + Arrays.deepHashCode(this.getTimestamps());
            return result;
        }

        public String toString() {
            return "VictoriaMetricsClusterDataStorage.VictoriaMetricsContent(metric=" + this.getMetric() + ", values=" + Arrays.deepToString(this.getValues()) + ", timestamps=" + Arrays.deepToString(this.getTimestamps()) + ")";
        }

        public VictoriaMetricsContent(Map<String, String> metric, Double[] values, Long[] timestamps) {
            this.metric = metric;
            this.values = values;
            this.timestamps = timestamps;
        }

        public VictoriaMetricsContent() {
        }

        public static class VictoriaMetricsContentBuilder {
            private Map<String, String> metric;
            private Double[] values;
            private Long[] timestamps;

            VictoriaMetricsContentBuilder() {
            }

            public VictoriaMetricsContentBuilder metric(Map<String, String> metric) {
                this.metric = metric;
                return this;
            }

            public VictoriaMetricsContentBuilder values(Double[] values) {
                this.values = values;
                return this;
            }

            public VictoriaMetricsContentBuilder timestamps(Long[] timestamps) {
                this.timestamps = timestamps;
                return this;
            }

            public VictoriaMetricsContent build() {
                return new VictoriaMetricsContent(this.metric, this.values, this.timestamps);
            }

            public String toString() {
                return "VictoriaMetricsClusterDataStorage.VictoriaMetricsContent.VictoriaMetricsContentBuilder(metric=" + this.metric + ", values=" + Arrays.deepToString(this.values) + ", timestamps=" + Arrays.deepToString(this.timestamps) + ")";
            }
        }
    }
}

