/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.obs.services.internal.ServiceException;
import java.io.IOException;

public class JSONChange {
    public static Object jsonToObj(Object obj, String jsonStr) throws ServiceException {
        MyObjectMapper mapper = ObjectMapperUtil.getInstance();
        try {
            obj = mapper.readValue(jsonStr, obj.getClass());
            return obj;
        }
        catch (JsonParseException e) {
            throw new ServiceException(" conversion JSON failed ", e);
        }
        catch (JsonMappingException e) {
            throw new ServiceException(" conversion JSON failed", e);
        }
        catch (IOException e) {
            throw new ServiceException(" conversion JSON failed", e);
        }
    }

    public static JsonNode readNodeFromJson(String jsonStr) throws ServiceException {
        MyObjectMapper mapper = ObjectMapperUtil.getInstance();
        try {
            JsonNode node = mapper.readTree(jsonStr);
            return node;
        }
        catch (IOException e) {
            throw new ServiceException(" read node failed", e);
        }
    }

    public static String objToJson(Object obj) throws ServiceException {
        MyObjectMapper mapper = ObjectMapperUtil.getInstance();
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new ServiceException("conversion JSON failed", e);
        }
    }

    private static class MyObjectMapper
    extends ObjectMapper {
        private static final long serialVersionUID = 4563671462132723274L;

        public MyObjectMapper() {
            this.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
            this.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
            this.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
            this.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
            this.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
            this.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            this.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.ALWAYS, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
            this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            this.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
            this.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            this.configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, true);
            this.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
            this.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.configure(SerializationFeature.INDENT_OUTPUT, false);
        }
    }

    private static class ObjectMapperUtil {
        private ObjectMapperUtil() {
        }

        public static MyObjectMapper getInstance() {
            return ObjectMapperUtilInstance.MAPPER;
        }

        private static class ObjectMapperUtilInstance {
            private static final MyObjectMapper MAPPER = new MyObjectMapper();

            private ObjectMapperUtilInstance() {
            }
        }
    }
}

