/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import java.time.Instant;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.ExternAlertService;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultExternAlertService
implements ExternAlertService {
    private static final Logger log = LoggerFactory.getLogger(DefaultExternAlertService.class);
    @Autowired
    private AlarmCommonReduce alarmCommonReduce;

    @Override
    public void addExternAlert(String content) {
        SingleAlert alert = (SingleAlert)JsonUtil.fromJson((String)content, SingleAlert.class);
        if (alert == null) {
            log.warn("parse extern alert content failed! content: {}", (Object)content);
            throw new IllegalArgumentException("parse extern alert content failed!");
        }
        alert.setId(null);
        String status = alert.getStatus();
        if (status == null) {
            status = alert.getStartAt() != null && alert.getEndAt() != null ? (alert.getEndAt() < Instant.now().toEpochMilli() ? "resolved" : "firing") : "firing";
        }
        alert.setStatus(status);
        if ("firing".equals(status)) {
            alert.setEndAt(null);
            if (alert.getStartAt() == null) {
                alert.setStartAt(Long.valueOf(Instant.now().toEpochMilli()));
            }
            if (alert.getActiveAt() == null) {
                alert.setActiveAt(Long.valueOf(Instant.now().toEpochMilli()));
            }
        } else {
            alert.setActiveAt(null);
            if (alert.getStartAt() == null) {
                alert.setStartAt(Long.valueOf(Instant.now().toEpochMilli()));
            }
            if (alert.getEndAt() == null) {
                alert.setEndAt(Long.valueOf(Instant.now().toEpochMilli()));
            }
        }
        this.alarmCommonReduce.reduceAndSendAlarm(alert);
    }

    @Override
    public String supportSource() {
        return "default";
    }
}

