/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate.periodic;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hertzbeat.alert.calculate.periodic.LogPeriodicAlertCalculator;
import org.apache.hertzbeat.alert.calculate.periodic.MetricsPeriodicAlertCalculator;
import org.apache.hertzbeat.alert.dao.AlertDefineDao;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class PeriodicAlertRuleScheduler
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(PeriodicAlertRuleScheduler.class);
    private final MetricsPeriodicAlertCalculator metricsCalculator;
    private final LogPeriodicAlertCalculator logCalculator;
    private final AlertDefineDao alertDefineDao;
    private final ScheduledExecutorService scheduledExecutor;
    private final Map<Long, ScheduledFuture<?>> scheduledFutures;

    public PeriodicAlertRuleScheduler(MetricsPeriodicAlertCalculator metricsCalculator, LogPeriodicAlertCalculator logCalculator, AlertDefineDao alertDefineDao) {
        this.metricsCalculator = metricsCalculator;
        this.logCalculator = logCalculator;
        this.alertDefineDao = alertDefineDao;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("Scheduled periodic alert threshold has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("periodic-alert-threshold-worker-%d").build();
        this.scheduledExecutor = Executors.newScheduledThreadPool(10, threadFactory);
        this.scheduledFutures = new ConcurrentHashMap();
    }

    public void cancelSchedule(Long ruleId) {
        if (ruleId == null) {
            return;
        }
        ScheduledFuture<?> future = this.scheduledFutures.get(ruleId);
        if (future != null) {
            future.cancel(true);
            this.scheduledFutures.remove(ruleId);
        }
    }

    public void updateSchedule(AlertDefine rule) {
        if (rule == null || rule.getId() == null) {
            log.error("Alert rule is null or rule id is null.");
            return;
        }
        this.cancelSchedule(rule.getId());
        if (rule.getType().equals("periodic_metric") || rule.getType().equals("periodic_log")) {
            ScheduledFuture<?> future = this.scheduledExecutor.scheduleAtFixedRate(() -> {
                if (rule.getType().equals("periodic_metric")) {
                    this.metricsCalculator.calculate(rule);
                } else if (rule.getType().equals("periodic_log")) {
                    this.logCalculator.calculate(rule);
                }
            }, 0L, rule.getPeriod().intValue(), TimeUnit.SECONDS);
            this.scheduledFutures.put(rule.getId(), future);
        }
    }

    public void run(String ... args) throws Exception {
        log.info("Starting periodic alert rule scheduler...");
        List<AlertDefine> metricsPeriodicRules = this.alertDefineDao.findAlertDefinesByTypeAndEnableTrue("periodic_metric");
        List<AlertDefine> logPeriodicRules = this.alertDefineDao.findAlertDefinesByTypeAndEnableTrue("periodic_log");
        ArrayList<AlertDefine> periodicRules = new ArrayList<AlertDefine>(metricsPeriodicRules.size() + logPeriodicRules.size());
        periodicRules.addAll(metricsPeriodicRules);
        periodicRules.addAll(logPeriodicRules);
        for (AlertDefine rule : periodicRules) {
            this.updateSchedule(rule);
        }
    }
}

