/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.log.notice;

import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.apache.hertzbeat.log.notice.LogSseFilterCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class LogSseManager {
    private static final Logger log = LoggerFactory.getLogger(LogSseManager.class);
    private static final long BATCH_INTERVAL_MS = 200L;
    private static final int MAX_BATCH_SIZE = 1000;
    private static final int MAX_QUEUE_SIZE = 10000;
    private final Map<Long, SseSubscriber> emitters = new ConcurrentHashMap<Long, SseSubscriber>();
    private final Queue<LogEntry> logQueue = new ConcurrentLinkedQueue<LogEntry>();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "sse-batch-scheduler");
        t.setDaemon(true);
        return t;
    });
    private final ExecutorService senderPool = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "sse-sender");
        t.setDaemon(true);
        return t;
    });
    private final AtomicLong queueSize = new AtomicLong(0L);

    public LogSseManager() {
        this.scheduler.scheduleAtFixedRate(this::flushBatch, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void shutdown() {
        this.scheduler.shutdown();
        this.senderPool.shutdown();
        try {
            this.scheduler.awaitTermination(2L, TimeUnit.SECONDS);
            this.senderPool.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.scheduler.shutdownNow();
        this.senderPool.shutdownNow();
    }

    public SseEmitter createEmitter(Long clientId, LogSseFilterCriteria filters) {
        SseEmitter emitter = new SseEmitter(Long.valueOf(Long.MAX_VALUE));
        emitter.onCompletion(() -> this.removeEmitter(clientId));
        emitter.onTimeout(() -> this.removeEmitter(clientId));
        emitter.onError(ex -> this.removeEmitter(clientId));
        this.emitters.put(clientId, new SseSubscriber(emitter, filters));
        return emitter;
    }

    public void broadcast(LogEntry logEntry) {
        if (this.queueSize.incrementAndGet() > 10000L) {
            this.queueSize.decrementAndGet();
            return;
        }
        boolean offered = this.logQueue.offer(logEntry);
        if (!offered) {
            this.queueSize.decrementAndGet();
            log.warn("Failed to enqueue log entry: {}", (Object)logEntry);
        }
    }

    private void flushBatch() {
        try {
            LogEntry entry;
            if (this.logQueue.isEmpty() || this.emitters.isEmpty()) {
                return;
            }
            ArrayList<LogEntry> batch = new ArrayList<LogEntry>(1000);
            while (batch.size() < 1000 && (entry = this.logQueue.poll()) != null) {
                batch.add(entry);
                this.queueSize.decrementAndGet();
            }
            if (batch.isEmpty()) {
                return;
            }
            for (Map.Entry<Long, SseSubscriber> e : this.emitters.entrySet()) {
                Long clientId = e.getKey();
                SseSubscriber subscriber = e.getValue();
                List<LogEntry> filtered = this.filterLogs(batch, subscriber.filters);
                if (filtered.isEmpty()) continue;
                this.senderPool.submit(() -> this.sendToSubscriber(clientId, subscriber.emitter, filtered));
            }
        }
        catch (Exception e) {
            log.error("Error in flushBatch: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void sendToSubscriber(Long clientId, SseEmitter emitter, List<LogEntry> logs) {
        try {
            long batchTimestamp = System.currentTimeMillis();
            int sequenceNumber = 0;
            for (LogEntry logEntry : logs) {
                String eventId = batchTimestamp + "-" + sequenceNumber++;
                emitter.send(SseEmitter.event().id(eventId).name("LOG_EVENT").data((Object)logEntry));
            }
        }
        catch (IOException | IllegalStateException e) {
            this.safeComplete(clientId, emitter);
        }
        catch (Exception e) {
            log.error("Failed to send to client {}: {}", (Object)clientId, (Object)e.getMessage());
            this.safeComplete(clientId, emitter);
        }
    }

    private void safeComplete(Long clientId, SseEmitter emitter) {
        try {
            emitter.complete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.removeEmitter(clientId);
    }

    private List<LogEntry> filterLogs(List<LogEntry> logs, LogSseFilterCriteria filters) {
        if (filters == null) {
            return logs;
        }
        ArrayList<LogEntry> filtered = new ArrayList<LogEntry>();
        for (LogEntry log : logs) {
            if (!filters.matches(log)) continue;
            filtered.add(log);
        }
        return filtered;
    }

    private void removeEmitter(Long clientId) {
        this.emitters.remove(clientId);
    }

    public long getQueueSize() {
        return this.queueSize.get();
    }

    public Map<Long, SseSubscriber> getEmitters() {
        return this.emitters;
    }

    public Queue<LogEntry> getLogQueue() {
        return this.logQueue;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public ExecutorService getSenderPool() {
        return this.senderPool;
    }

    public static class SseSubscriber {
        private SseEmitter emitter;
        private LogSseFilterCriteria filters;

        public SseEmitter getEmitter() {
            return this.emitter;
        }

        public LogSseFilterCriteria getFilters() {
            return this.filters;
        }

        public void setEmitter(SseEmitter emitter) {
            this.emitter = emitter;
        }

        public void setFilters(LogSseFilterCriteria filters) {
            this.filters = filters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SseSubscriber)) {
                return false;
            }
            SseSubscriber other = (SseSubscriber)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SseEmitter this$emitter = this.getEmitter();
            SseEmitter other$emitter = other.getEmitter();
            if (this$emitter == null ? other$emitter != null : !this$emitter.equals(other$emitter)) {
                return false;
            }
            LogSseFilterCriteria this$filters = this.getFilters();
            LogSseFilterCriteria other$filters = other.getFilters();
            return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SseSubscriber;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SseEmitter $emitter = this.getEmitter();
            result = result * 59 + ($emitter == null ? 43 : $emitter.hashCode());
            LogSseFilterCriteria $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            return result;
        }

        public String toString() {
            return "LogSseManager.SseSubscriber(emitter=" + this.getEmitter() + ", filters=" + this.getFilters() + ")";
        }

        public SseSubscriber(SseEmitter emitter, LogSseFilterCriteria filters) {
            this.emitter = emitter;
            this.filters = filters;
        }

        public SseSubscriber() {
        }
    }
}

