/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.log.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.log.service.LogProtocolAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Log Ingestion Controller")
@RestController
@RequestMapping(path={"/api/logs"}, produces={"application/json"})
public class LogIngestionController {
    private static final Logger log = LoggerFactory.getLogger(LogIngestionController.class);
    private final List<LogProtocolAdapter> protocolAdapters;

    public LogIngestionController(List<LogProtocolAdapter> protocolAdapters) {
        this.protocolAdapters = protocolAdapters;
    }

    @Operation(summary="Ingest logs by protocol name")
    @PostMapping(value={"/ingest/{protocol}"}, consumes={"application/json"})
    public ResponseEntity<Message<Void>> ingestLog(@PathVariable(value="protocol") String protocol, @RequestBody String content) {
        log.debug("Receive log from protocol: {}, content length: {}", (Object)protocol, (Object)(content == null ? 0 : content.length()));
        for (LogProtocolAdapter adapter : this.protocolAdapters) {
            if (!adapter.supportProtocol().equalsIgnoreCase(protocol)) continue;
            try {
                adapter.ingest(content);
                return ResponseEntity.ok((Object)Message.success((String)"Add extern log success"));
            }
            catch (Exception e) {
                log.error("Add log failed: {}", (Object)e.getMessage(), (Object)e);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)Message.fail((byte)15, (String)("Add extern log failed: " + e.getMessage())));
            }
        }
        log.warn("Not support extern log from protocol: {}", (Object)protocol);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)Message.fail((byte)15, (String)("Not support the " + protocol + " protocol log")));
    }
}

