/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.CloneableMutable;
import io.questdb.std.str.DirectCharSequence;
import io.questdb.std.str.MutableUtf16Sink;
import io.questdb.std.str.Utf16Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlyweightDirectUtf16Sink
implements MutableUtf16Sink,
DirectCharSequence,
CloneableMutable {
    private long hi = 0L;
    private long lo = 0L;
    private long ptr = 0L;

    public long appendPtr() {
        return this.lo;
    }

    public FlyweightDirectUtf16Sink asCharSequence(long lo, long hi) {
        this.ptr = lo;
        this.lo = hi;
        this.hi = hi;
        return this;
    }

    @Override
    public char charAt(int index) {
        return Unsafe.getUnsafe().getChar(this.ptr + (long)index * 2L);
    }

    @Override
    public void clear() {
        this.clear(0);
    }

    public void clear(int len) {
        this.lo = this.ptr + (long)len;
    }

    public void close() {
        this.ptr = 0L;
        this.hi = 0L;
        this.lo = 0L;
    }

    @Override
    public <T> T copy() {
        return (T)this.toString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CharSequence && Chars.equals((CharSequence)this, (CharSequence)obj);
    }

    public int hashCode() {
        return Chars.hashCode(this);
    }

    @Override
    public int length() {
        return (int)(this.lo - this.ptr) / 2;
    }

    public FlyweightDirectUtf16Sink of(long lo, long hi) {
        this.ptr = lo;
        this.lo = lo;
        this.hi = hi;
        return this;
    }

    @Override
    public long ptr() {
        return this.ptr;
    }

    @Override
    public Utf16Sink put(@Nullable CharSequence cs) {
        if (cs != null) {
            int l = cs.length();
            assert (this.checkCapacity(l));
            int l2 = l * 2;
            for (int i = 0; i < l; ++i) {
                Unsafe.getUnsafe().putChar(this.lo + (long)i * 2L, cs.charAt(i));
            }
            this.lo += (long)l2;
        }
        return this;
    }

    @Override
    public Utf16Sink put(char @NotNull [] chars, int start, int len) {
        assert (this.checkCapacity(len));
        int l2 = len * 2;
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putChar(this.lo + (long)i * 2L, chars[i + start]);
        }
        this.lo += (long)l2;
        return this;
    }

    @Override
    public Utf16Sink put(char c) {
        assert (this.checkCapacity(1));
        Unsafe.getUnsafe().putChar(this.lo, c);
        this.lo += 2L;
        return this;
    }

    @Override
    public int size() {
        return (int)(this.lo - this.ptr);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String toString() {
        return AbstractCharSequence.getString(this);
    }

    private boolean checkCapacity(int nChars) {
        return this.lo + 2L * (long)nChars <= this.hi;
    }
}

