/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import io.questdb.std.ex.FatalError;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8StringSink;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;

public final class Misc {
    public static final int CACHE_LINE_SIZE = 64;
    public static final String EOL = "\r\n";
    private static final ThreadLocal<StringSink> tlSink = new ThreadLocal<StringSink>(StringSink::new);
    private static final ThreadLocal<Utf8StringSink> tlUtf8Sink = new ThreadLocal<Utf8StringSink>(Utf8StringSink::new);

    private Misc() {
    }

    public static <T extends Mutable> T clear(T object) {
        if (object != null) {
            object.clear();
        }
        return null;
    }

    public static void clearObjList(ObjList<? extends Mutable> args) {
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Mutable m = args.getQuick(i);
            if (m == null) continue;
            m.clear();
        }
    }

    public static <T extends Closeable> T free(T object) {
        if (object != null) {
            try {
                object.close();
            }
            catch (IOException e) {
                throw new FatalError(e);
            }
        }
        return null;
    }

    public static <T extends Closeable> void free(T[] list) {
        if (list != null) {
            int n = list.length;
            for (int i = 0; i < n; ++i) {
                list[i] = Misc.free(list[i]);
            }
        }
    }

    public static <T> T freeIfCloseable(T object) {
        if (object instanceof Closeable) {
            try {
                ((Closeable)object).close();
            }
            catch (IOException e) {
                throw new FatalError(e);
            }
        }
        return null;
    }

    public static <T extends Closeable> void freeObjList(ObjList<T> list) {
        if (list != null) {
            Misc.freeObjList0(list);
        }
    }

    public static <T extends Closeable> void freeObjListAndClear(ObjList<T> list) {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Misc.free((Closeable)list.getQuick(i));
            }
            list.clear();
        }
    }

    public static <T extends Closeable> void freeObjListAndKeepObjects(ObjList<T> list) {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Misc.free((Closeable)list.getQuick(i));
            }
        }
    }

    public static <T> void freeObjListIfCloseable(ObjList<T> list) {
        if (list != null) {
            Misc.freeObjList0(list);
        }
    }

    public static StringSink getThreadLocalSink() {
        StringSink b = tlSink.get();
        b.clear();
        return b;
    }

    public static Utf8StringSink getThreadLocalUtf8Sink() {
        Utf8StringSink b = tlUtf8Sink.get();
        b.clear();
        return b;
    }

    public static int[] getWorkerAffinity(int workerCount) {
        int[] res = new int[workerCount];
        Arrays.fill(res, -1);
        return res;
    }

    private static <T> void freeObjList0(ObjList<T> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.setQuick(i, Misc.freeIfCloseable(list.getQuick(i)));
        }
    }
}

